/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.file;

import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import java.beans.Transient;
import java.lang.ref.SoftReference;
import java.util.Map;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.testingisdocumenting.webtau.Matchers;
import org.testingisdocumenting.webtau.WebTauCore;
import org.testingisdocumenting.znai.extensions.include.PluginsTestUtils;
import org.testingisdocumenting.znai.utils.ResourceUtils;
import znaishaded.org.junit.Test;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class FileIncludePluginTest
implements GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ SoftReference $callSiteArray;

    @Generated
    public FileIncludePluginTest() {
        MetaClass metaClass;
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    @Test
    public void should trim empty lines from start and end() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[0].callStatic(FileIncludePluginTest.class, (Object)"file-with-empty-lines.txt", (Object)"");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-with-empty-lines.txt", "");
            text = string;
        }
        callSiteArray[1].call(text, callSiteArray[2].callStatic(WebTauCore.class, callSiteArray[3].call(callSiteArray[4].call(callSiteArray[5].call(callSiteArray[6].call(callSiteArray[7].call(callSiteArray[8].call(callSiteArray[9].call(callSiteArray[10].call((Object)"this is a\n", (Object)"\n"), (Object)"a multiple lines\n"), (Object)"\n"), (Object)"line number\n"), (Object)"--- stop\n"), (Object)"and five\n"), (Object)"\n"), (Object)"and then six")));
    }

    @Test
    public void should extract file snippet based on start line and number of lines() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[11].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{startLine: 'multiple lines', numberOfLines: 2}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{startLine: 'multiple lines', numberOfLines: 2}");
            text = string;
        }
        callSiteArray[12].call(text, callSiteArray[13].callStatic(WebTauCore.class, callSiteArray[14].call((Object)"a multiple lines\n", (Object)"line number")));
    }

    @Test
    public void should extract file snippet based on start and stop end lines() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[15].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{startLine: 'multiple lines', endLine: 'stop'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{startLine: 'multiple lines', endLine: 'stop'}");
            text = string;
        }
        callSiteArray[16].call(text, callSiteArray[17].callStatic(WebTauCore.class, callSiteArray[18].call(callSiteArray[19].call((Object)"a multiple lines\n", (Object)"line number\n"), (Object)"--- stop")));
    }

    @Test
    public void should extract not match start line to the end line pattern but start from the one below() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[20].callStatic(FileIncludePluginTest.class, (Object)"file-with-similar-lines.txt", (Object)"{startLine: '$prompt >', endLine: '$prompt >'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-with-similar-lines.txt", "{startLine: '$prompt >', endLine: '$prompt >'}");
            text = string;
        }
        callSiteArray[21].call(text, callSiteArray[22].callStatic(WebTauCore.class, callSiteArray[23].call(callSiteArray[24].call(callSiteArray[25].call((Object)"$prompt >\n", (Object)"some output\n"), (Object)"goes here\n"), (Object)"$prompt >")));
    }

    @Test
    public void should fail when surrounded content is empty() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_fail_when_surrounded_content_is_empty_closure1
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_fail_when_surrounded_content_is_empty_closure1(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_fail_when_surrounded_content_is_empty_closure1.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_fail_when_surrounded_content_is_empty_closure1.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file-with-similar-lines-empty.txt", (Object)"{surroundedBy: '$prompt'}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_fail_when_surrounded_content_is_empty_closure1.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_fail_when_surrounded_content_is_empty_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_fail_when_surrounded_content_is_empty_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_fail_when_surrounded_content_is_empty_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[26].call(callSiteArray[27].callStatic(Matchers.class, (Object)new _should_fail_when_surrounded_content_is_empty_closure1(this, this)), callSiteArray[28].callStatic(Matchers.class, (Object)"no content present after surroundedBy $prompt"));
    }

    @Test
    public void should fail if one of the surroundedBy is missing() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_fail_if_one_of_the_surroundedBy_is_missing_closure2
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_fail_if_one_of_the_surroundedBy_is_missing_closure2(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_fail_if_one_of_the_surroundedBy_is_missing_closure2.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_fail_if_one_of_the_surroundedBy_is_missing_closure2.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file-with-missing-marker.txt", (Object)"{surroundedBy: '$prompt'}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_fail_if_one_of_the_surroundedBy_is_missing_closure2.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_fail_if_one_of_the_surroundedBy_is_missing_closure2.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_fail_if_one_of_the_surroundedBy_is_missing_closure2.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_fail_if_one_of_the_surroundedBy_is_missing_closure2.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[29].call(callSiteArray[30].callStatic(Matchers.class, (Object)new _should_fail_if_one_of_the_surroundedBy_is_missing_closure2(this, this)), callSiteArray[31].callStatic(Matchers.class, callSiteArray[32].call(callSiteArray[33].call(callSiteArray[34].call((Object)"there is no second marker \"$prompt\" in <file-with-missing-marker.txt>:\n", (Object)"$prompt >\n"), (Object)"some output\n"), (Object)"goes here")));
    }

    @Test
    public void should validate start and stop end lines() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_validate_start_and_stop_end_lines_closure3
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_start_and_stop_end_lines_closure3(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_start_and_stop_end_lines_closure3.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_start_and_stop_end_lines_closure3.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file.txt", (Object)"{startLine: '1multiple lines', endLine: 'stop'}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_start_and_stop_end_lines_closure3.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_start_and_stop_end_lines_closure3.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_validate_start_and_stop_end_lines_closure3.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_start_and_stop_end_lines_closure3.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[35].call(callSiteArray[36].callStatic(Matchers.class, (Object)new _should_validate_start_and_stop_end_lines_closure3(this, this)), callSiteArray[37].callStatic(Matchers.class, callSiteArray[38].call(callSiteArray[39].call(callSiteArray[40].call(callSiteArray[41].call(callSiteArray[42].call(callSiteArray[43].call(callSiteArray[44].call((Object)"there is no line containing \"1multiple lines\" in <file.txt>:\n", (Object)"this is a\n"), (Object)"test file in\n"), (Object)"a multiple lines\n"), (Object)"line number\n"), (Object)"--- stop\n"), (Object)"and five\n"), (Object)"and then six")));
        public final class _should_validate_start_and_stop_end_lines_closure4
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_start_and_stop_end_lines_closure4(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_start_and_stop_end_lines_closure4.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_start_and_stop_end_lines_closure4.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file.txt", (Object)"{startLine: 'multiple lines', endLine: 'stop2'}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_start_and_stop_end_lines_closure4.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_start_and_stop_end_lines_closure4.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_validate_start_and_stop_end_lines_closure4.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_start_and_stop_end_lines_closure4.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[45].call(callSiteArray[46].callStatic(Matchers.class, (Object)new _should_validate_start_and_stop_end_lines_closure4(this, this)), callSiteArray[47].callStatic(Matchers.class, callSiteArray[48].call(callSiteArray[49].call(callSiteArray[50].call(callSiteArray[51].call(callSiteArray[52].call((Object)"there is no line containing \"stop2\" in <file.txt>:\n", (Object)"a multiple lines\n"), (Object)"line number\n"), (Object)"--- stop\n"), (Object)"and five\n"), (Object)"and then six")));
    }

    @Test
    public void should extract file snippet based on start and stop end lines excluding them() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[53].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{startLine: 'number', endLine: 'stop', excludeStartEnd: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{startLine: 'number', endLine: 'stop', excludeStartEnd: true}");
            text = string;
        }
        callSiteArray[54].call(text, callSiteArray[55].callStatic(WebTauCore.class, (Object)""));
    }

    @Test
    public void multiple start lines() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[56].callStatic(FileIncludePluginTest.class, (Object)"multiple-lines-start-stop.txt", (Object)"{startLine: ['if (conditionA)', 'if (conditionB)']}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("multiple-lines-start-stop.txt", "{startLine: ['if (conditionA)', 'if (conditionB)']}");
            text = string;
        }
        callSiteArray[57].call(text, callSiteArray[58].callStatic(WebTauCore.class, callSiteArray[59].call(callSiteArray[60].call(callSiteArray[61].call(callSiteArray[62].call(callSiteArray[63].call(callSiteArray[64].call(callSiteArray[65].call(callSiteArray[66].call(callSiteArray[67].call(callSiteArray[68].call((Object)"if (conditionA) {\n", (Object)"  // line between\n"), (Object)"  if (conditionB) {\n"), (Object)"    // inside condition A and condition B\n"), (Object)"    doAction()\n"), (Object)"  }\n"), (Object)"}\n"), (Object)"\n"), (Object)"if (conditionC) {\n"), (Object)"    // inside condition C\n"), (Object)"}")));
    }

    @Test
    public void multiple start lines no match() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _multiple_start_lines_no_match_closure5
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _multiple_start_lines_no_match_closure5(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _multiple_start_lines_no_match_closure5.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _multiple_start_lines_no_match_closure5.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"multiple-lines-start-stop.txt", (Object)"{startLine: ['if (conditionA)', 'if (conditionD)']}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _multiple_start_lines_no_match_closure5.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _multiple_start_lines_no_match_closure5.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_multiple_start_lines_no_match_closure5.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _multiple_start_lines_no_match_closure5.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[69].call(callSiteArray[70].callStatic(Matchers.class, (Object)new _multiple_start_lines_no_match_closure5(this, this)), callSiteArray[71].callStatic(Matchers.class, callSiteArray[72].call(callSiteArray[73].call(callSiteArray[74].call((Object)"can't find sequence of start lines:\n", (Object)"  if (conditionA)\n"), (Object)"  if (conditionD) in <multiple-lines-start-stop.txt>:\n"), callSiteArray[75].call(callSiteArray[76].call(ResourceUtils.class, (Object)"multiple-lines-start-stop.txt")))));
    }

    @Test
    public void multiple start lines with exclude start() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[77].callStatic(FileIncludePluginTest.class, (Object)"multiple-lines-start-stop.txt", (Object)"{startLine: ['if (conditionA)', 'if (conditionB)'], excludeStart: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("multiple-lines-start-stop.txt", "{startLine: ['if (conditionA)', 'if (conditionB)'], excludeStart: true}");
            text = string;
        }
        callSiteArray[78].call(text, callSiteArray[79].callStatic(WebTauCore.class, callSiteArray[80].call(callSiteArray[81].call(callSiteArray[82].call(callSiteArray[83].call(callSiteArray[84].call(callSiteArray[85].call(callSiteArray[86].call((Object)"    // inside condition A and condition B\n", (Object)"    doAction()\n"), (Object)"  }\n"), (Object)"}\n"), (Object)"\n"), (Object)"if (conditionC) {\n"), (Object)"    // inside condition C\n"), (Object)"}")));
    }

    @Test
    public void multiple start lines with include last start line() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[87].callStatic(FileIncludePluginTest.class, (Object)"multiple-lines-start-stop.txt", (Object)"{startLine: ['if (conditionA)', 'if (conditionB)'], startLineKeepLast: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("multiple-lines-start-stop.txt", "{startLine: ['if (conditionA)', 'if (conditionB)'], startLineKeepLast: true}");
            text = string;
        }
        callSiteArray[88].call(text, callSiteArray[89].callStatic(WebTauCore.class, callSiteArray[90].call(callSiteArray[91].call(callSiteArray[92].call(callSiteArray[93].call(callSiteArray[94].call(callSiteArray[95].call(callSiteArray[96].call(callSiteArray[97].call((Object)"  if (conditionB) {\n", (Object)"    // inside condition A and condition B\n"), (Object)"    doAction()\n"), (Object)"  }\n"), (Object)"}\n"), (Object)"\n"), (Object)"if (conditionC) {\n"), (Object)"    // inside condition C\n"), (Object)"}")));
    }

    @Test
    public void should extract file snippet based on surrounding pattern and exclude the pattern() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[98].callStatic(FileIncludePluginTest.class, (Object)"file-with-surround-marker.txt", (Object)"{surroundedBy: '# concept-example'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-with-surround-marker.txt", "{surroundedBy: '# concept-example'}");
            text = string;
        }
        callSiteArray[99].call(text, callSiteArray[100].callStatic(WebTauCore.class, callSiteArray[101].call((Object)"foo()\n", (Object)"bar()")));
    }

    @Test
    public void surrounded by keep() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[102].callStatic(FileIncludePluginTest.class, (Object)"file-with-surround-marker.txt", (Object)"{surroundedBy: '# concept-example', surroundedByKeep: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-with-surround-marker.txt", "{surroundedBy: '# concept-example', surroundedByKeep: true}");
            text = string;
        }
        callSiteArray[103].call(text, callSiteArray[104].callStatic(WebTauCore.class, callSiteArray[105].call(callSiteArray[106].call(callSiteArray[107].call((Object)"# concept-example\n", (Object)"   foo()\n"), (Object)"   bar()\n"), (Object)"# concept-example")));
    }

    @Test
    public void should extract file snippet based on multiple surrounding patterns and indent each block() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[108].callStatic(FileIncludePluginTest.class, (Object)"file-with-multiple-surround-marker.txt", (Object)"{surroundedBy: ['# import-list', '# concept-example']}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-with-multiple-surround-marker.txt", "{surroundedBy: ['# import-list', '# concept-example']}");
            text = string;
        }
        callSiteArray[109].call(text, callSiteArray[110].callStatic(WebTauCore.class, callSiteArray[111].call(callSiteArray[112].call(callSiteArray[113].call((Object)"import abc\n", (Object)"import def\n"), (Object)"foo()\n"), (Object)"bar()")));
    }

    @Test
    public void should extract file snippet based on multiple surrounding patterns and add specified separator() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = callSiteArray[114].callStatic(FileIncludePluginTest.class, (Object)"file-with-multiple-surround-marker.txt", callSiteArray[115].call((Object)"{surroundedBy: ['# import-list', '# concept-example', '# another-example', '# next-last-example', '# last-example', ],", (Object)" surroundedBySeparator: ['...', null, '%']}"));
        callSiteArray[116].call(text, callSiteArray[117].callStatic(WebTauCore.class, callSiteArray[118].call(callSiteArray[119].call(callSiteArray[120].call(callSiteArray[121].call(callSiteArray[122].call(callSiteArray[123].call(callSiteArray[124].call(callSiteArray[125].call(callSiteArray[126].call((Object)"import abc\n", (Object)"import def\n"), (Object)"...\n"), (Object)"foo()\n"), (Object)"bar()\n"), (Object)"foobar()\n"), (Object)"%\n"), (Object)"almostFinish()\n"), (Object)"%\n"), (Object)"finish()")));
    }

    @Test
    public void should extract using surrounded with scope() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[127].callStatic(FileIncludePluginTest.class, (Object)"file-with-scopes.txt", (Object)"{surroundedByScope: {start: 'if', scope: '{}'}}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-with-scopes.txt", "{surroundedByScope: {start: 'if', scope: '{}'}}");
            text = string;
        }
        callSiteArray[128].call(text, callSiteArray[129].callStatic(WebTauCore.class, callSiteArray[130].call(callSiteArray[131].call((Object)"if (condition) {\n", (Object)"   print \"inside\"\n"), (Object)"}")));
    }

    @Test
    public void surrounded with scope validates presence of start line() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _surrounded_with_scope_validates_presence_of_start_line_closure6
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _surrounded_with_scope_validates_presence_of_start_line_closure6(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _surrounded_with_scope_validates_presence_of_start_line_closure6.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _surrounded_with_scope_validates_presence_of_start_line_closure6.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file-with-scopes.txt", (Object)"{surroundedByScope: {start: 'if-else', scope: '{}'}}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _surrounded_with_scope_validates_presence_of_start_line_closure6.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _surrounded_with_scope_validates_presence_of_start_line_closure6.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_surrounded_with_scope_validates_presence_of_start_line_closure6.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _surrounded_with_scope_validates_presence_of_start_line_closure6.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[132].call(callSiteArray[133].callStatic(Matchers.class, (Object)new _surrounded_with_scope_validates_presence_of_start_line_closure6(this, this)), callSiteArray[134].callStatic(Matchers.class, callSiteArray[135].call((Object)"there is no line containing \"if-else\" in <file-with-scopes.txt>:\n", callSiteArray[136].call(callSiteArray[137].call(ResourceUtils.class, (Object)"file-with-scopes.txt")))));
    }

    @Test
    public void surrounded with scope validates presence of markers() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _surrounded_with_scope_validates_presence_of_markers_closure7
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _surrounded_with_scope_validates_presence_of_markers_closure7(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _surrounded_with_scope_validates_presence_of_markers_closure7.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _surrounded_with_scope_validates_presence_of_markers_closure7.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file-with-scopes.txt", (Object)"{surroundedByScope: {start: 'if (anotherCondition)', scope: '{}'}}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _surrounded_with_scope_validates_presence_of_markers_closure7.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _surrounded_with_scope_validates_presence_of_markers_closure7.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_surrounded_with_scope_validates_presence_of_markers_closure7.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _surrounded_with_scope_validates_presence_of_markers_closure7.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[138].call(callSiteArray[139].callStatic(Matchers.class, (Object)new _surrounded_with_scope_validates_presence_of_markers_closure7(this, this)), callSiteArray[140].callStatic(Matchers.class, callSiteArray[141].call((Object)"can't find scope start \"{\" after line \"if (anotherCondition)\" in <file-with-scopes.txt>:\n", callSiteArray[142].call(callSiteArray[143].call(ResourceUtils.class, (Object)"file-with-scopes.txt")))));
        public final class _surrounded_with_scope_validates_presence_of_markers_closure8
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _surrounded_with_scope_validates_presence_of_markers_closure8(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _surrounded_with_scope_validates_presence_of_markers_closure8.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _surrounded_with_scope_validates_presence_of_markers_closure8.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file-with-scopes.txt", (Object)"{surroundedByScope: {start: 'if (someCondition)', scope: '{}'}}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _surrounded_with_scope_validates_presence_of_markers_closure8.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _surrounded_with_scope_validates_presence_of_markers_closure8.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_surrounded_with_scope_validates_presence_of_markers_closure8.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _surrounded_with_scope_validates_presence_of_markers_closure8.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[144].call(callSiteArray[145].callStatic(Matchers.class, (Object)new _surrounded_with_scope_validates_presence_of_markers_closure8(this, this)), callSiteArray[146].callStatic(Matchers.class, callSiteArray[147].call((Object)"can't find scope end \"}\" after line \"if (someCondition)\" in <file-with-scopes.txt>:\n", callSiteArray[148].call(callSiteArray[149].call(ResourceUtils.class, (Object)"file-with-scopes.txt")))));
    }

    @Test
    public void should replace text by exact match() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[150].callStatic(FileIncludePluginTest.class, (Object)"file-replace-all.txt", (Object)"{replace: ['foo', 'foo2']}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-replace-all.txt", "{replace: ['foo', 'foo2']}");
            text = string;
        }
        callSiteArray[151].call(text, callSiteArray[152].callStatic(WebTauCore.class, callSiteArray[153].call(callSiteArray[154].call((Object)"foo2 foo2 foo2\n", (Object)"bar bar bar\n"), (Object)"test12 great16")));
    }

    @Test
    public void should replace text by exact match using multiple pairs() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[155].callStatic(FileIncludePluginTest.class, (Object)"file-replace-all.txt", (Object)"{replace: [['foo', 'foo2'], ['bar', 'bar3']]}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-replace-all.txt", "{replace: [['foo', 'foo2'], ['bar', 'bar3']]}");
            text = string;
        }
        callSiteArray[156].call(text, callSiteArray[157].callStatic(WebTauCore.class, callSiteArray[158].call(callSiteArray[159].call((Object)"foo2 foo2 foo2\n", (Object)"bar3 bar3 bar3\n"), (Object)"test12 great16")));
    }

    @Test
    public void should replace text using match group() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[160].callStatic(FileIncludePluginTest.class, (Object)"file-replace-all.txt", (Object)"{replace: ['test(\\\\d+)', '$1-TEST']}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-replace-all.txt", "{replace: ['test(\\\\d+)', '$1-TEST']}");
            text = string;
        }
        callSiteArray[161].call(text, callSiteArray[162].callStatic(WebTauCore.class, callSiteArray[163].call(callSiteArray[164].call((Object)"foo foo foo\n", (Object)"bar bar bar\n"), (Object)"12-TEST great16")));
    }

    @Test
    public void should replace text inside surroundBy extracted group() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[165].callStatic(FileIncludePluginTest.class, (Object)"file-with-multiple-surround-marker.txt", (Object)"{surroundedBy: ['# import-list', '# concept-example'], replace: [['abc', 'ABC'], ['bar', 'Bar']]}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file-with-multiple-surround-marker.txt", "{surroundedBy: ['# import-list', '# concept-example'], replace: [['abc', 'ABC'], ['bar', 'Bar']]}");
            text = string;
        }
        callSiteArray[166].call(text, callSiteArray[167].callStatic(WebTauCore.class, callSiteArray[168].call(callSiteArray[169].call(callSiteArray[170].call((Object)"import ABC\n", (Object)"import def\n"), (Object)"foo()\n"), (Object)"Bar()")));
    }

    @Test
    public void should validate replace parameters() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        String expectedError = "replace expects list with two values [from, to] or a list of pairs [[from1, to1], [from2, to2]]";
        public final class _should_validate_replace_parameters_closure9
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_replace_parameters_closure9(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_replace_parameters_closure9.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_replace_parameters_closure9.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file-replace-all.txt", (Object)"{replace: ['a']}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_replace_parameters_closure9.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_replace_parameters_closure9.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_validate_replace_parameters_closure9.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_replace_parameters_closure9.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[171].call(callSiteArray[172].callStatic(Matchers.class, (Object)new _should_validate_replace_parameters_closure9(this, this)), callSiteArray[173].callStatic(Matchers.class, (Object)expectedError));
        public final class _should_validate_replace_parameters_closure10
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_replace_parameters_closure10(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_replace_parameters_closure10.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_replace_parameters_closure10.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file-replace-all.txt", (Object)"{replace: [['a']]}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_replace_parameters_closure10.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_replace_parameters_closure10.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_validate_replace_parameters_closure10.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_replace_parameters_closure10.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[174].call(callSiteArray[175].callStatic(Matchers.class, (Object)new _should_validate_replace_parameters_closure10(this, this)), callSiteArray[176].callStatic(Matchers.class, (Object)expectedError));
    }

    @Test
    public void should validate replace actually replaced something() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_validate_replace_actually_replaced_something_closure11
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_replace_actually_replaced_something_closure11(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_replace_actually_replaced_something_closure11.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_replace_actually_replaced_something_closure11.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file-replace-all.txt", (Object)"{replace: ['no-match', 'new-value']}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_replace_actually_replaced_something_closure11.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_replace_actually_replaced_something_closure11.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_validate_replace_actually_replaced_something_closure11.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_replace_actually_replaced_something_closure11.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[177].call(callSiteArray[178].callStatic(Matchers.class, (Object)new _should_validate_replace_actually_replaced_something_closure11(this, this)), callSiteArray[179].callStatic(Matchers.class, (Object)"content was not modified using replace from: <no-match> to: <new-value>"));
    }

    @Test
    public void should extract file and exclude first and last line when excludeStartEnd is set and no start end is set() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[180].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{excludeStartEnd: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{excludeStartEnd: true}");
            text = string;
        }
        callSiteArray[181].call(text, callSiteArray[182].callStatic(WebTauCore.class, callSiteArray[183].call(callSiteArray[184].call(callSiteArray[185].call(callSiteArray[186].call((Object)"test file in\n", (Object)"a multiple lines\n"), (Object)"line number\n"), (Object)"--- stop\n"), (Object)"and five")));
    }

    @Test
    public void should extract file snippet based on start line only() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[187].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{startLine: 'multiple lines'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{startLine: 'multiple lines'}");
            text = string;
        }
        callSiteArray[188].call(text, callSiteArray[189].callStatic(WebTauCore.class, callSiteArray[190].call(callSiteArray[191].call(callSiteArray[192].call(callSiteArray[193].call((Object)"a multiple lines\n", (Object)"line number\n"), (Object)"--- stop\n"), (Object)"and five\n"), (Object)"and then six")));
    }

    @Test
    public void should throw when start line is empty() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_throw_when_start_line_is_empty_closure12
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_throw_when_start_line_is_empty_closure12(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_throw_when_start_line_is_empty_closure12.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_throw_when_start_line_is_empty_closure12.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file.txt", (Object)"{startLine: ''}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_throw_when_start_line_is_empty_closure12.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_throw_when_start_line_is_empty_closure12.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_throw_when_start_line_is_empty_closure12.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_throw_when_start_line_is_empty_closure12.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[194].call(callSiteArray[195].callStatic(Matchers.class, (Object)new _should_throw_when_start_line_is_empty_closure12(this, this)), callSiteArray[196].callStatic(Matchers.class, (Object)"<startLine> contains empty line"));
        public final class _should_throw_when_start_line_is_empty_closure13
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_throw_when_start_line_is_empty_closure13(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_throw_when_start_line_is_empty_closure13.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_throw_when_start_line_is_empty_closure13.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file.txt", (Object)"{startLine: ['line', '']}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_throw_when_start_line_is_empty_closure13.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_throw_when_start_line_is_empty_closure13.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_throw_when_start_line_is_empty_closure13.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_throw_when_start_line_is_empty_closure13.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[197].call(callSiteArray[198].callStatic(Matchers.class, (Object)new _should_throw_when_start_line_is_empty_closure13(this, this)), callSiteArray[199].callStatic(Matchers.class, (Object)"<startLine> contains empty line"));
    }

    @Test
    public void should extract file snippet based on start line and exclude only start() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[200].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{startLine: 'this is a', excludeStart: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{startLine: 'this is a', excludeStart: true}");
            text = string;
        }
        callSiteArray[201].call(text, callSiteArray[202].callStatic(WebTauCore.class, callSiteArray[203].call(callSiteArray[204].call(callSiteArray[205].call(callSiteArray[206].call(callSiteArray[207].call((Object)"test file in\n", (Object)"a multiple lines\n"), (Object)"line number\n"), (Object)"--- stop\n"), (Object)"and five\n"), (Object)"and then six")));
    }

    @Test
    public void should extract file snippet based on end line and exclude only end() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[208].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{endLine: '--- stop', excludeEnd: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{endLine: '--- stop', excludeEnd: true}");
            text = string;
        }
        callSiteArray[209].call(text, callSiteArray[210].callStatic(WebTauCore.class, callSiteArray[211].call(callSiteArray[212].call(callSiteArray[213].call((Object)"this is a\n", (Object)"test file in\n"), (Object)"a multiple lines\n"), (Object)"line number")));
    }

    @Test
    public void should throw when end line is empty() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_throw_when_end_line_is_empty_closure14
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_throw_when_end_line_is_empty_closure14(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_throw_when_end_line_is_empty_closure14.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_throw_when_end_line_is_empty_closure14.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file.txt", (Object)"{endLine: ''}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_throw_when_end_line_is_empty_closure14.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_throw_when_end_line_is_empty_closure14.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_throw_when_end_line_is_empty_closure14.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_throw_when_end_line_is_empty_closure14.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[214].call(callSiteArray[215].callStatic(Matchers.class, (Object)new _should_throw_when_end_line_is_empty_closure14(this, this)), callSiteArray[216].callStatic(Matchers.class, (Object)"<endLine> contains empty line"));
        public final class _should_throw_when_end_line_is_empty_closure15
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_throw_when_end_line_is_empty_closure15(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_throw_when_end_line_is_empty_closure15.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_throw_when_end_line_is_empty_closure15.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"file.txt", (Object)"{endLine: ['line', '']}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_throw_when_end_line_is_empty_closure15.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_throw_when_end_line_is_empty_closure15.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_throw_when_end_line_is_empty_closure15.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_throw_when_end_line_is_empty_closure15.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[217].call(callSiteArray[218].callStatic(Matchers.class, (Object)new _should_throw_when_end_line_is_empty_closure15(this, this)), callSiteArray[219].callStatic(Matchers.class, (Object)"<endLine> contains empty line"));
    }

    @Test
    public void should extract file snippet based on end line only() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[220].callStatic(FileIncludePluginTest.class, (Object)"file.txt", (Object)"{endLine: 'stop'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("file.txt", "{endLine: 'stop'}");
            text = string;
        }
        callSiteArray[221].call(text, callSiteArray[222].callStatic(WebTauCore.class, callSiteArray[223].call(callSiteArray[224].call(callSiteArray[225].call(callSiteArray[226].call((Object)"this is a\n", (Object)"test file in\n"), (Object)"a multiple lines\n"), (Object)"line number\n"), (Object)"--- stop")));
    }

    @Test
    public void should extract file snippet based on multiple end lines() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[227].callStatic(FileIncludePluginTest.class, (Object)"multiple-lines-start-stop.txt", (Object)"{endLine: ['if (conditionB)', '}', '}']}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("multiple-lines-start-stop.txt", "{endLine: ['if (conditionB)', '}', '}']}");
            text = string;
        }
        callSiteArray[228].call(text, callSiteArray[229].callStatic(WebTauCore.class, callSiteArray[230].call(callSiteArray[231].call(callSiteArray[232].call(callSiteArray[233].call(callSiteArray[234].call(callSiteArray[235].call(callSiteArray[236].call(callSiteArray[237].call(callSiteArray[238].call(callSiteArray[239].call(callSiteArray[240].call(callSiteArray[241].call(callSiteArray[242].call(callSiteArray[243].call((Object)"if (conditionA) {\n", (Object)"    // inside condition A\n"), (Object)"}\n"), (Object)"\n"), (Object)"if (conditionB) {\n"), (Object)"    // inside condition B\n"), (Object)"}\n"), (Object)"\n"), (Object)"if (conditionA) {\n"), (Object)"  // line between\n"), (Object)"  if (conditionB) {\n"), (Object)"    // inside condition A and condition B\n"), (Object)"    doAction()\n"), (Object)"  }\n"), (Object)"}")));
    }

    @Test
    public void should extract file snippet based on multiple end lines with exclude end() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[244].callStatic(FileIncludePluginTest.class, (Object)"multiple-lines-start-stop.txt", (Object)"{endLine: ['}', '}'], excludeEnd: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("multiple-lines-start-stop.txt", "{endLine: ['}', '}'], excludeEnd: true}");
            text = string;
        }
        callSiteArray[245].call(text, callSiteArray[246].callStatic(WebTauCore.class, callSiteArray[247].call(callSiteArray[248].call(callSiteArray[249].call(callSiteArray[250].call(callSiteArray[251].call(callSiteArray[252].call(callSiteArray[253].call(callSiteArray[254].call(callSiteArray[255].call(callSiteArray[256].call(callSiteArray[257].call(callSiteArray[258].call((Object)"if (conditionA) {\n", (Object)"    // inside condition A\n"), (Object)"}\n"), (Object)"\n"), (Object)"if (conditionB) {\n"), (Object)"    // inside condition B\n"), (Object)"}\n"), (Object)"\n"), (Object)"if (conditionA) {\n"), (Object)"  // line between\n"), (Object)"  if (conditionB) {\n"), (Object)"    // inside condition A and condition B\n"), (Object)"    doAction()")));
    }

    @Test
    public void should extract file snippet based on multiple end lines with exclude end and keep first end line() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[259].callStatic(FileIncludePluginTest.class, (Object)"multiple-lines-start-stop.txt", (Object)"{endLine: ['}', '}'], excludeEnd: true, endLineKeepFirst: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("multiple-lines-start-stop.txt", "{endLine: ['}', '}'], excludeEnd: true, endLineKeepFirst: true}");
            text = string;
        }
        callSiteArray[260].call(text, callSiteArray[261].callStatic(WebTauCore.class, callSiteArray[262].call(callSiteArray[263].call(callSiteArray[264].call(callSiteArray[265].call(callSiteArray[266].call(callSiteArray[267].call(callSiteArray[268].call(callSiteArray[269].call(callSiteArray[270].call(callSiteArray[271].call(callSiteArray[272].call(callSiteArray[273].call(callSiteArray[274].call((Object)"if (conditionA) {\n", (Object)"    // inside condition A\n"), (Object)"}\n"), (Object)"\n"), (Object)"if (conditionB) {\n"), (Object)"    // inside condition B\n"), (Object)"}\n"), (Object)"\n"), (Object)"if (conditionA) {\n"), (Object)"  // line between\n"), (Object)"  if (conditionB) {\n"), (Object)"    // inside condition A and condition B\n"), (Object)"    doAction()\n"), (Object)"  }")));
    }

    @Test
    public void should extract file snippet based on multiple start and end lines with exclude end and keep first and last lines() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = callSiteArray[275].callStatic(FileIncludePluginTest.class, (Object)"multiple-lines-start-stop.txt", callSiteArray[276].call((Object)"{startLine: ['if (conditionA)', 'if (conditionB)'], endLine: ['}', '}'], excludeStartEnd: true, ", (Object)"startLineKeepLast: true, endLineKeepFirst: true}"));
        callSiteArray[277].call(text, callSiteArray[278].callStatic(WebTauCore.class, callSiteArray[279].call(callSiteArray[280].call(callSiteArray[281].call((Object)"if (conditionB) {\n", (Object)"  // inside condition A and condition B\n"), (Object)"  doAction()\n"), (Object)"}")));
    }

    @Test
    public void should extract file snippet based on multiple end lines no match() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_extract_file_snippet_based_on_multiple_end_lines_no_match_closure16
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_extract_file_snippet_based_on_multiple_end_lines_no_match_closure16(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_extract_file_snippet_based_on_multiple_end_lines_no_match_closure16.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_extract_file_snippet_based_on_multiple_end_lines_no_match_closure16.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"multiple-lines-start-stop.txt", (Object)"{endLine: ['if (conditionA)', 'if (conditionD)']}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_extract_file_snippet_based_on_multiple_end_lines_no_match_closure16.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_extract_file_snippet_based_on_multiple_end_lines_no_match_closure16.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_extract_file_snippet_based_on_multiple_end_lines_no_match_closure16.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_extract_file_snippet_based_on_multiple_end_lines_no_match_closure16.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[282].call(callSiteArray[283].callStatic(Matchers.class, (Object)new _should_extract_file_snippet_based_on_multiple_end_lines_no_match_closure16(this, this)), callSiteArray[284].callStatic(Matchers.class, callSiteArray[285].call(callSiteArray[286].call(callSiteArray[287].call((Object)"can't find sequence of end lines:\n", (Object)"  if (conditionA)\n"), (Object)"  if (conditionD) in <multiple-lines-start-stop.txt>:\n"), callSiteArray[288].call(callSiteArray[289].call(ResourceUtils.class, (Object)"multiple-lines-start-stop.txt")))));
    }

    @Test
    public void should automatically strip extra indentation() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object text = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            text = object = callSiteArray[290].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{startLine: 'class', endLine: '}', excludeStartEnd: true}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("script.groovy", "{startLine: 'class', endLine: '}', excludeStartEnd: true}");
            text = string;
        }
        callSiteArray[291].call(text, callSiteArray[292].callStatic(WebTauCore.class, callSiteArray[293].call((Object)"def a\n", (Object)"int b")));
    }

    @Test
    public void should only include lines containing text() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object result = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            result = object = callSiteArray[294].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{include: ['int', 'def']}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("script.groovy", "{include: ['int', 'def']}");
            result = string;
        }
        callSiteArray[295].call(result, callSiteArray[296].callStatic(WebTauCore.class, callSiteArray[297].call((Object)"def a\n", (Object)"int b")));
    }

    @Test
    public void should fail if none of the contains matches() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_fail_if_none_of_the_contains_matches_closure17
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_fail_if_none_of_the_contains_matches_closure17(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_contains_matches_closure17.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_contains_matches_closure17.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"script.groovy", (Object)"{include: ['in2t', 'de2f']}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_contains_matches_closure17.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_fail_if_none_of_the_contains_matches_closure17.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_fail_if_none_of_the_contains_matches_closure17.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_fail_if_none_of_the_contains_matches_closure17.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[298].call(callSiteArray[299].callStatic(Matchers.class, (Object)new _should_fail_if_none_of_the_contains_matches_closure17(this, this)), callSiteArray[300].callStatic(Matchers.class, callSiteArray[301].call(callSiteArray[302].call(callSiteArray[303].call(callSiteArray[304].call(callSiteArray[305].call(callSiteArray[306].call(callSiteArray[307].call((Object)"there are no lines containing <in2t>, <de2f> in <script.groovy>:\n", (Object)"import e.d.g.AnotherName\n"), (Object)"import a.b.c.ClassName\n"), (Object)"\n"), (Object)"class HelloWorld {\n"), (Object)"    def a\n"), (Object)"    int b\n"), (Object)"}")));
    }

    @Test
    public void should only include lines matching regexp() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object singleImport = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            singleImport = object = callSiteArray[308].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{includeRegexp: 'import.*ClassName'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("script.groovy", "{includeRegexp: 'import.*ClassName'}");
            singleImport = string;
        }
        callSiteArray[309].call(singleImport, callSiteArray[310].callStatic(WebTauCore.class, (Object)"import a.b.c.ClassName"));
        Object allImports = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            allImports = object = callSiteArray[311].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{includeRegexp: 'import'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("script.groovy", "{includeRegexp: 'import'}");
            allImports = string;
        }
        callSiteArray[312].call(allImports, callSiteArray[313].callStatic(WebTauCore.class, callSiteArray[314].call((Object)"import e.d.g.AnotherName\n", (Object)"import a.b.c.ClassName")));
    }

    @Test
    public void should only include lines matching regexps list() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object result = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            result = object = callSiteArray[315].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{includeRegexp: ['i.t', 'd.f']}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("script.groovy", "{includeRegexp: ['i.t', 'd.f']}");
            result = string;
        }
        callSiteArray[316].call(result, callSiteArray[317].callStatic(WebTauCore.class, callSiteArray[318].call((Object)"def a\n", (Object)"int b")));
    }

    @Test
    public void should fail if none of the include regexps matches() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_fail_if_none_of_the_include_regexps_matches_closure18
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_fail_if_none_of_the_include_regexps_matches_closure18(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_include_regexps_matches_closure18.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_include_regexps_matches_closure18.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"script.groovy", (Object)"{includeRegexp: ['in2t', 'de2f']}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_include_regexps_matches_closure18.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_fail_if_none_of_the_include_regexps_matches_closure18.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_fail_if_none_of_the_include_regexps_matches_closure18.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_fail_if_none_of_the_include_regexps_matches_closure18.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[319].call(callSiteArray[320].callStatic(Matchers.class, (Object)new _should_fail_if_none_of_the_include_regexps_matches_closure18(this, this)), callSiteArray[321].callStatic(Matchers.class, callSiteArray[322].call(callSiteArray[323].call(callSiteArray[324].call(callSiteArray[325].call(callSiteArray[326].call(callSiteArray[327].call(callSiteArray[328].call((Object)"there are no lines matching regexp <in2t>, <de2f> in <script.groovy>:\n", (Object)"import e.d.g.AnotherName\n"), (Object)"import a.b.c.ClassName\n"), (Object)"\n"), (Object)"class HelloWorld {\n"), (Object)"    def a\n"), (Object)"    int b\n"), (Object)"}")));
    }

    @Test
    public void should exclude lines that don't contain text() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object withoutMarkers = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            withoutMarkers = object = callSiteArray[329].callStatic(FileIncludePluginTest.class, (Object)"sample-with-marker.py", (Object)"{exclude: '# example'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("sample-with-marker.py", "{exclude: '# example'}");
            withoutMarkers = string;
        }
        callSiteArray[330].call(withoutMarkers, callSiteArray[331].callStatic(WebTauCore.class, (Object)"print(\"hello\")"));
    }

    @Test
    public void should fail if none of the exclude contains matches() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_fail_if_none_of_the_exclude_contains_matches_closure19
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_fail_if_none_of_the_exclude_contains_matches_closure19(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_exclude_contains_matches_closure19.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_exclude_contains_matches_closure19.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"sample-with-multi-marker.py", (Object)"{exclude: [\"# exam34ple\", \"# .roc3edur.\"]}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_exclude_contains_matches_closure19.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_fail_if_none_of_the_exclude_contains_matches_closure19.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_fail_if_none_of_the_exclude_contains_matches_closure19.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_fail_if_none_of_the_exclude_contains_matches_closure19.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[332].call(callSiteArray[333].callStatic(Matchers.class, (Object)new _should_fail_if_none_of_the_exclude_contains_matches_closure19(this, this)), callSiteArray[334].callStatic(Matchers.class, callSiteArray[335].call(callSiteArray[336].call(callSiteArray[337].call(callSiteArray[338].call(callSiteArray[339].call(callSiteArray[340].call(callSiteArray[341].call((Object)"there are no lines containing <# exam34ple>, <# .roc3edur.> in <sample-with-multi-marker.py>:\n", (Object)"# example: how to print\n"), (Object)"print(\"hello\")\n"), (Object)"# example-end\n"), (Object)"\n"), (Object)"# procedure: how to print\n"), (Object)"print(\"hello world\")\n"), (Object)"# procedure-end")));
    }

    @Test
    public void should exclude lines matching regexp() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object withoutMarkers = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            withoutMarkers = object = callSiteArray[342].callStatic(FileIncludePluginTest.class, (Object)"sample-with-marker.py", (Object)"{excludeRegexp: '# exa..le'}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("sample-with-marker.py", "{excludeRegexp: '# exa..le'}");
            withoutMarkers = string;
        }
        callSiteArray[343].call(withoutMarkers, callSiteArray[344].callStatic(WebTauCore.class, (Object)"print(\"hello\")"));
    }

    @Test
    public void should exclude lines matching regexps list() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object withoutMarkers = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            withoutMarkers = object = callSiteArray[345].callStatic(FileIncludePluginTest.class, (Object)"sample-with-multi-marker.py", (Object)"{excludeRegexp: [\"# example\", \"# .rocedur.\"]}");
        } else {
            String string = FileIncludePluginTest.resultingSnippet("sample-with-multi-marker.py", "{excludeRegexp: [\"# example\", \"# .rocedur.\"]}");
            withoutMarkers = string;
        }
        callSiteArray[346].call(withoutMarkers, callSiteArray[347].callStatic(WebTauCore.class, callSiteArray[348].call(callSiteArray[349].call((Object)"print(\"hello\")\n", (Object)"\n"), (Object)"print(\"hello world\")")));
    }

    @Test
    public void should fail if none of the exclude regexp matches() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_fail_if_none_of_the_exclude_regexp_matches_closure20
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_fail_if_none_of_the_exclude_regexp_matches_closure20(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_exclude_regexp_matches_closure20.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_exclude_regexp_matches_closure20.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"sample-with-multi-marker.py", (Object)"{excludeRegexp: [\"# exam34ple\", \"# .roc3edur.\"]}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_fail_if_none_of_the_exclude_regexp_matches_closure20.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_fail_if_none_of_the_exclude_regexp_matches_closure20.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_fail_if_none_of_the_exclude_regexp_matches_closure20.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_fail_if_none_of_the_exclude_regexp_matches_closure20.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[350].call(callSiteArray[351].callStatic(Matchers.class, (Object)new _should_fail_if_none_of_the_exclude_regexp_matches_closure20(this, this)), callSiteArray[352].callStatic(Matchers.class, callSiteArray[353].call(callSiteArray[354].call(callSiteArray[355].call(callSiteArray[356].call(callSiteArray[357].call(callSiteArray[358].call(callSiteArray[359].call((Object)"there are no lines matching regexp <# exam34ple>, <# .roc3edur.> in <sample-with-multi-marker.py>:\n", (Object)"# example: how to print\n"), (Object)"print(\"hello\")\n"), (Object)"# example-end\n"), (Object)"\n"), (Object)"# procedure: how to print\n"), (Object)"print(\"hello world\")\n"), (Object)"# procedure-end")));
    }

    @Test
    public void should validate highlight lines presence when highlight is a line idx() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[360].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{highlight: 3}");
        } else {
            FileIncludePluginTest.resultingSnippet("script.groovy", "{highlight: 3}");
        }
        public final class _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure21
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure21(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure21.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure21.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"script.groovy", (Object)"{highlight: 7}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure21.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure21.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure21.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure21.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[361].call(callSiteArray[362].callStatic(Matchers.class, (Object)new _should_validate_highlight_lines_presence_when_highlight_is_a_line_idx_closure21(this, this)), callSiteArray[363].callStatic(Matchers.class, callSiteArray[364].call((Object)"highlight idx is out of range: 7\n", (Object)"check: script.groovy")));
    }

    @Test
    public void should validate highlight lines presence when highlight is a text() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[365].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{highlight: 'def a'}");
        } else {
            FileIncludePluginTest.resultingSnippet("script.groovy", "{highlight: 'def a'}");
        }
        public final class _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure22
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure22(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure22.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure22.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"script.groovy", (Object)"{highlight: 'def c'}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure22.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure22.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingSnippet";
                return new CallSiteArray(_should_validate_highlight_lines_presence_when_highlight_is_a_text_closure22.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure22.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[366].call(callSiteArray[367].callStatic(Matchers.class, (Object)new _should_validate_highlight_lines_presence_when_highlight_is_a_text_closure22(this, this)), callSiteArray[368].callStatic(Matchers.class, callSiteArray[369].call(callSiteArray[370].call(callSiteArray[371].call(callSiteArray[372].call(callSiteArray[373].call(callSiteArray[374].call(callSiteArray[375].call(callSiteArray[376].call((Object)"highlight text <def c> is not found\n", (Object)"check: script.groovy\n"), (Object)"import e.d.g.AnotherName\n"), (Object)"import a.b.c.ClassName\n"), (Object)"\n"), (Object)"class HelloWorld {\n"), (Object)"    def a\n"), (Object)"    int b\n"), (Object)"}")));
    }

    @Test
    public void should highlight lines based on contains() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object props = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            props = object = callSiteArray[377].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{highlight: 'class'}");
        } else {
            Map<String, Object> map = FileIncludePluginTest.resultingProps("script.groovy", "{highlight: 'class'}");
            props = map;
        }
        callSiteArray[378].call(callSiteArray[379].callGetProperty(props), callSiteArray[380].callStatic(WebTauCore.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{3})));
    }

    @Test
    public void should highlight all lines based on contains() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object props = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            props = object = callSiteArray[381].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{highlight: 'import'}");
        } else {
            Map<String, Object> map = FileIncludePluginTest.resultingProps("script.groovy", "{highlight: 'import'}");
            props = map;
        }
        callSiteArray[382].call(callSiteArray[383].callGetProperty(props), callSiteArray[384].callStatic(WebTauCore.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{0, 1})));
    }

    @Test
    public void should highlight lines from a highlight text file() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        Object props = null;
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            Object object;
            props = object = callSiteArray[385].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{highlightPath: 'highlight.txt'}");
        } else {
            Map<String, Object> map = FileIncludePluginTest.resultingProps("script.groovy", "{highlightPath: 'highlight.txt'}");
            props = map;
        }
        callSiteArray[386].call(callSiteArray[387].callGetProperty(props), callSiteArray[388].callStatic(WebTauCore.class, (Object)ScriptBytecodeAdapter.createList((Object[])new Object[]{4, 5})));
    }

    @Test
    public void when title is not set should auto generate title based file name() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        if (__$stMC || BytecodeInterface8.disabledStandardMetaClass()) {
            callSiteArray[389].call(callSiteArray[390].callGetProperty(callSiteArray[391].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{autoTitle: true}")), callSiteArray[392].callStatic(WebTauCore.class, (Object)"script.groovy"));
            callSiteArray[393].call(callSiteArray[394].callGetProperty(callSiteArray[395].callStatic(FileIncludePluginTest.class, (Object)"script.groovy", (Object)"{autoTitle: false}")), callSiteArray[396].callStatic(WebTauCore.class, null));
        } else {
            callSiteArray[397].call(callSiteArray[398].callGetProperty(FileIncludePluginTest.resultingProps("script.groovy", "{autoTitle: true}")), callSiteArray[399].callStatic(WebTauCore.class, (Object)"script.groovy"));
            callSiteArray[400].call(callSiteArray[401].callGetProperty(FileIncludePluginTest.resultingProps("script.groovy", "{autoTitle: false}")), callSiteArray[402].callStatic(WebTauCore.class, null));
        }
    }

    @Test
    public void should not allow autoTitle and title() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_not_allow_autoTitle_and_title_closure23
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_not_allow_autoTitle_and_title_closure23(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_not_allow_autoTitle_and_title_closure23.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_not_allow_autoTitle_and_title_closure23.$getCallSiteArray();
                return callSiteArray[0].call(callSiteArray[1].callGetProperty(callSiteArray[2].callCurrent((GroovyObject)this, (Object)"script.groovy", (Object)"{title: 'hello', autoTitle: false}")), callSiteArray[3].callStatic(WebTauCore.class, null));
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_not_allow_autoTitle_and_title_closure23.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_not_allow_autoTitle_and_title_closure23.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
                stringArray[0] = "should";
                stringArray[1] = "title";
                stringArray[2] = "resultingProps";
                stringArray[3] = "equal";
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[4];
                _should_not_allow_autoTitle_and_title_closure23.$createCallSiteArray_1(stringArray);
                return new CallSiteArray(_should_not_allow_autoTitle_and_title_closure23.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_not_allow_autoTitle_and_title_closure23.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[403].call(callSiteArray[404].callStatic(Matchers.class, (Object)new _should_not_allow_autoTitle_and_title_closure23(this, this)), callSiteArray[405].callStatic(Matchers.class, (Object)"Can't have both <title> and <autoTitle> specified"));
    }

    @Test
    public void should validate lines from a highlight text file() {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        public final class _should_validate_lines_from_a_highlight_text_file_closure24
        extends Closure
        implements GeneratedClosure {
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public _should_validate_lines_from_a_highlight_text_file_closure24(Object _outerInstance, Object _thisObject) {
                CallSite[] callSiteArray = _should_validate_lines_from_a_highlight_text_file_closure24.$getCallSiteArray();
                super(_outerInstance, _thisObject);
            }

            public Object doCall(Object it) {
                CallSite[] callSiteArray = _should_validate_lines_from_a_highlight_text_file_closure24.$getCallSiteArray();
                return callSiteArray[0].callCurrent((GroovyObject)this, (Object)"script.groovy", (Object)"{highlightPath: 'missing-highlight.txt'}");
            }

            @Generated
            public Object doCall() {
                CallSite[] callSiteArray = _should_validate_lines_from_a_highlight_text_file_closure24.$getCallSiteArray();
                return this.doCall(null);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _should_validate_lines_from_a_highlight_text_file_closure24.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[1];
                stringArray[0] = "resultingProps";
                return new CallSiteArray(_should_validate_lines_from_a_highlight_text_file_closure24.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _should_validate_lines_from_a_highlight_text_file_closure24.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }
        }
        callSiteArray[406].call(callSiteArray[407].callStatic(Matchers.class, (Object)new _should_validate_lines_from_a_highlight_text_file_closure24(this, this)), callSiteArray[408].callStatic(Matchers.class, ScriptBytecodeAdapter.bitwiseNegate((Object)"highlightPath text <def g> is not found")));
    }

    private static String resultingSnippet(String fileName, String value) {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        return ShortTypeHandling.castToString((Object)callSiteArray[409].call(PluginsTestUtils.class, (Object)new GStringImpl(new Object[]{fileName, value}, new String[]{":include-file: ", " ", ""})));
    }

    private static Map<String, Object> resultingProps(String fileName, String value) {
        CallSite[] callSiteArray = FileIncludePluginTest.$getCallSiteArray();
        return (Map)ScriptBytecodeAdapter.castToType((Object)callSiteArray[410].call(PluginsTestUtils.class, (Object)new GStringImpl(new Object[]{fileName, value}, new String[]{":include-file: ", " ", ""})), Map.class);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != FileIncludePluginTest.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    @Transient
    public MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    private static /* synthetic */ void $createCallSiteArray_1(String[] stringArray) {
        stringArray[0] = "resultingSnippet";
        stringArray[1] = "should";
        stringArray[2] = "equal";
        stringArray[3] = "plus";
        stringArray[4] = "plus";
        stringArray[5] = "plus";
        stringArray[6] = "plus";
        stringArray[7] = "plus";
        stringArray[8] = "plus";
        stringArray[9] = "plus";
        stringArray[10] = "plus";
        stringArray[11] = "resultingSnippet";
        stringArray[12] = "should";
        stringArray[13] = "equal";
        stringArray[14] = "plus";
        stringArray[15] = "resultingSnippet";
        stringArray[16] = "should";
        stringArray[17] = "equal";
        stringArray[18] = "plus";
        stringArray[19] = "plus";
        stringArray[20] = "resultingSnippet";
        stringArray[21] = "should";
        stringArray[22] = "equal";
        stringArray[23] = "plus";
        stringArray[24] = "plus";
        stringArray[25] = "plus";
        stringArray[26] = "should";
        stringArray[27] = "code";
        stringArray[28] = "throwException";
        stringArray[29] = "should";
        stringArray[30] = "code";
        stringArray[31] = "throwException";
        stringArray[32] = "plus";
        stringArray[33] = "plus";
        stringArray[34] = "plus";
        stringArray[35] = "should";
        stringArray[36] = "code";
        stringArray[37] = "throwException";
        stringArray[38] = "plus";
        stringArray[39] = "plus";
        stringArray[40] = "plus";
        stringArray[41] = "plus";
        stringArray[42] = "plus";
        stringArray[43] = "plus";
        stringArray[44] = "plus";
        stringArray[45] = "should";
        stringArray[46] = "code";
        stringArray[47] = "throwException";
        stringArray[48] = "plus";
        stringArray[49] = "plus";
        stringArray[50] = "plus";
        stringArray[51] = "plus";
        stringArray[52] = "plus";
        stringArray[53] = "resultingSnippet";
        stringArray[54] = "should";
        stringArray[55] = "equal";
        stringArray[56] = "resultingSnippet";
        stringArray[57] = "should";
        stringArray[58] = "equal";
        stringArray[59] = "plus";
        stringArray[60] = "plus";
        stringArray[61] = "plus";
        stringArray[62] = "plus";
        stringArray[63] = "plus";
        stringArray[64] = "plus";
        stringArray[65] = "plus";
        stringArray[66] = "plus";
        stringArray[67] = "plus";
        stringArray[68] = "plus";
        stringArray[69] = "should";
        stringArray[70] = "code";
        stringArray[71] = "throwException";
        stringArray[72] = "plus";
        stringArray[73] = "plus";
        stringArray[74] = "plus";
        stringArray[75] = "trim";
        stringArray[76] = "textContent";
        stringArray[77] = "resultingSnippet";
        stringArray[78] = "should";
        stringArray[79] = "equal";
        stringArray[80] = "plus";
        stringArray[81] = "plus";
        stringArray[82] = "plus";
        stringArray[83] = "plus";
        stringArray[84] = "plus";
        stringArray[85] = "plus";
        stringArray[86] = "plus";
        stringArray[87] = "resultingSnippet";
        stringArray[88] = "should";
        stringArray[89] = "equal";
        stringArray[90] = "plus";
        stringArray[91] = "plus";
        stringArray[92] = "plus";
        stringArray[93] = "plus";
        stringArray[94] = "plus";
        stringArray[95] = "plus";
        stringArray[96] = "plus";
        stringArray[97] = "plus";
        stringArray[98] = "resultingSnippet";
        stringArray[99] = "should";
        stringArray[100] = "equal";
        stringArray[101] = "plus";
        stringArray[102] = "resultingSnippet";
        stringArray[103] = "should";
        stringArray[104] = "equal";
        stringArray[105] = "plus";
        stringArray[106] = "plus";
        stringArray[107] = "plus";
        stringArray[108] = "resultingSnippet";
        stringArray[109] = "should";
        stringArray[110] = "equal";
        stringArray[111] = "plus";
        stringArray[112] = "plus";
        stringArray[113] = "plus";
        stringArray[114] = "resultingSnippet";
        stringArray[115] = "plus";
        stringArray[116] = "should";
        stringArray[117] = "equal";
        stringArray[118] = "plus";
        stringArray[119] = "plus";
        stringArray[120] = "plus";
        stringArray[121] = "plus";
        stringArray[122] = "plus";
        stringArray[123] = "plus";
        stringArray[124] = "plus";
        stringArray[125] = "plus";
        stringArray[126] = "plus";
        stringArray[127] = "resultingSnippet";
        stringArray[128] = "should";
        stringArray[129] = "equal";
        stringArray[130] = "plus";
        stringArray[131] = "plus";
        stringArray[132] = "should";
        stringArray[133] = "code";
        stringArray[134] = "throwException";
        stringArray[135] = "plus";
        stringArray[136] = "trim";
        stringArray[137] = "textContent";
        stringArray[138] = "should";
        stringArray[139] = "code";
        stringArray[140] = "throwException";
        stringArray[141] = "plus";
        stringArray[142] = "trim";
        stringArray[143] = "textContent";
        stringArray[144] = "should";
        stringArray[145] = "code";
        stringArray[146] = "throwException";
        stringArray[147] = "plus";
        stringArray[148] = "trim";
        stringArray[149] = "textContent";
        stringArray[150] = "resultingSnippet";
        stringArray[151] = "should";
        stringArray[152] = "equal";
        stringArray[153] = "plus";
        stringArray[154] = "plus";
        stringArray[155] = "resultingSnippet";
        stringArray[156] = "should";
        stringArray[157] = "equal";
        stringArray[158] = "plus";
        stringArray[159] = "plus";
        stringArray[160] = "resultingSnippet";
        stringArray[161] = "should";
        stringArray[162] = "equal";
        stringArray[163] = "plus";
        stringArray[164] = "plus";
        stringArray[165] = "resultingSnippet";
        stringArray[166] = "should";
        stringArray[167] = "equal";
        stringArray[168] = "plus";
        stringArray[169] = "plus";
        stringArray[170] = "plus";
        stringArray[171] = "should";
        stringArray[172] = "code";
        stringArray[173] = "throwException";
        stringArray[174] = "should";
        stringArray[175] = "code";
        stringArray[176] = "throwException";
        stringArray[177] = "should";
        stringArray[178] = "code";
        stringArray[179] = "throwException";
        stringArray[180] = "resultingSnippet";
        stringArray[181] = "should";
        stringArray[182] = "equal";
        stringArray[183] = "plus";
        stringArray[184] = "plus";
        stringArray[185] = "plus";
        stringArray[186] = "plus";
        stringArray[187] = "resultingSnippet";
        stringArray[188] = "should";
        stringArray[189] = "equal";
        stringArray[190] = "plus";
        stringArray[191] = "plus";
        stringArray[192] = "plus";
        stringArray[193] = "plus";
        stringArray[194] = "should";
        stringArray[195] = "code";
        stringArray[196] = "throwException";
        stringArray[197] = "should";
        stringArray[198] = "code";
        stringArray[199] = "throwException";
        stringArray[200] = "resultingSnippet";
        stringArray[201] = "should";
        stringArray[202] = "equal";
        stringArray[203] = "plus";
        stringArray[204] = "plus";
        stringArray[205] = "plus";
        stringArray[206] = "plus";
        stringArray[207] = "plus";
        stringArray[208] = "resultingSnippet";
        stringArray[209] = "should";
        stringArray[210] = "equal";
        stringArray[211] = "plus";
        stringArray[212] = "plus";
        stringArray[213] = "plus";
        stringArray[214] = "should";
        stringArray[215] = "code";
        stringArray[216] = "throwException";
        stringArray[217] = "should";
        stringArray[218] = "code";
        stringArray[219] = "throwException";
        stringArray[220] = "resultingSnippet";
        stringArray[221] = "should";
        stringArray[222] = "equal";
        stringArray[223] = "plus";
        stringArray[224] = "plus";
        stringArray[225] = "plus";
        stringArray[226] = "plus";
        stringArray[227] = "resultingSnippet";
        stringArray[228] = "should";
        stringArray[229] = "equal";
        stringArray[230] = "plus";
        stringArray[231] = "plus";
        stringArray[232] = "plus";
        stringArray[233] = "plus";
        stringArray[234] = "plus";
        stringArray[235] = "plus";
        stringArray[236] = "plus";
        stringArray[237] = "plus";
        stringArray[238] = "plus";
        stringArray[239] = "plus";
        stringArray[240] = "plus";
        stringArray[241] = "plus";
        stringArray[242] = "plus";
        stringArray[243] = "plus";
        stringArray[244] = "resultingSnippet";
        stringArray[245] = "should";
        stringArray[246] = "equal";
        stringArray[247] = "plus";
        stringArray[248] = "plus";
        stringArray[249] = "plus";
        stringArray[250] = "plus";
        stringArray[251] = "plus";
        stringArray[252] = "plus";
        stringArray[253] = "plus";
        stringArray[254] = "plus";
        stringArray[255] = "plus";
        stringArray[256] = "plus";
        stringArray[257] = "plus";
        stringArray[258] = "plus";
        stringArray[259] = "resultingSnippet";
        stringArray[260] = "should";
        stringArray[261] = "equal";
        stringArray[262] = "plus";
        stringArray[263] = "plus";
        stringArray[264] = "plus";
        stringArray[265] = "plus";
        stringArray[266] = "plus";
        stringArray[267] = "plus";
        stringArray[268] = "plus";
        stringArray[269] = "plus";
        stringArray[270] = "plus";
        stringArray[271] = "plus";
        stringArray[272] = "plus";
        stringArray[273] = "plus";
        stringArray[274] = "plus";
        stringArray[275] = "resultingSnippet";
        stringArray[276] = "plus";
        stringArray[277] = "should";
        stringArray[278] = "equal";
        stringArray[279] = "plus";
        stringArray[280] = "plus";
        stringArray[281] = "plus";
        stringArray[282] = "should";
        stringArray[283] = "code";
        stringArray[284] = "throwException";
        stringArray[285] = "plus";
        stringArray[286] = "plus";
        stringArray[287] = "plus";
        stringArray[288] = "trim";
        stringArray[289] = "textContent";
        stringArray[290] = "resultingSnippet";
        stringArray[291] = "should";
        stringArray[292] = "equal";
        stringArray[293] = "plus";
        stringArray[294] = "resultingSnippet";
        stringArray[295] = "should";
        stringArray[296] = "equal";
        stringArray[297] = "plus";
        stringArray[298] = "should";
        stringArray[299] = "code";
        stringArray[300] = "throwException";
        stringArray[301] = "plus";
        stringArray[302] = "plus";
        stringArray[303] = "plus";
        stringArray[304] = "plus";
        stringArray[305] = "plus";
        stringArray[306] = "plus";
        stringArray[307] = "plus";
        stringArray[308] = "resultingSnippet";
        stringArray[309] = "should";
        stringArray[310] = "equal";
        stringArray[311] = "resultingSnippet";
        stringArray[312] = "should";
        stringArray[313] = "equal";
        stringArray[314] = "plus";
        stringArray[315] = "resultingSnippet";
        stringArray[316] = "should";
        stringArray[317] = "equal";
        stringArray[318] = "plus";
        stringArray[319] = "should";
        stringArray[320] = "code";
        stringArray[321] = "throwException";
        stringArray[322] = "plus";
        stringArray[323] = "plus";
        stringArray[324] = "plus";
        stringArray[325] = "plus";
        stringArray[326] = "plus";
        stringArray[327] = "plus";
        stringArray[328] = "plus";
        stringArray[329] = "resultingSnippet";
        stringArray[330] = "should";
        stringArray[331] = "equal";
        stringArray[332] = "should";
        stringArray[333] = "code";
        stringArray[334] = "throwException";
        stringArray[335] = "plus";
        stringArray[336] = "plus";
        stringArray[337] = "plus";
        stringArray[338] = "plus";
        stringArray[339] = "plus";
        stringArray[340] = "plus";
        stringArray[341] = "plus";
        stringArray[342] = "resultingSnippet";
        stringArray[343] = "should";
        stringArray[344] = "equal";
        stringArray[345] = "resultingSnippet";
        stringArray[346] = "should";
        stringArray[347] = "equal";
        stringArray[348] = "plus";
        stringArray[349] = "plus";
        stringArray[350] = "should";
        stringArray[351] = "code";
        stringArray[352] = "throwException";
        stringArray[353] = "plus";
        stringArray[354] = "plus";
        stringArray[355] = "plus";
        stringArray[356] = "plus";
        stringArray[357] = "plus";
        stringArray[358] = "plus";
        stringArray[359] = "plus";
        stringArray[360] = "resultingSnippet";
        stringArray[361] = "should";
        stringArray[362] = "code";
        stringArray[363] = "throwException";
        stringArray[364] = "plus";
        stringArray[365] = "resultingSnippet";
        stringArray[366] = "should";
        stringArray[367] = "code";
        stringArray[368] = "throwException";
        stringArray[369] = "plus";
        stringArray[370] = "plus";
        stringArray[371] = "plus";
        stringArray[372] = "plus";
        stringArray[373] = "plus";
        stringArray[374] = "plus";
        stringArray[375] = "plus";
        stringArray[376] = "plus";
        stringArray[377] = "resultingProps";
        stringArray[378] = "should";
        stringArray[379] = "highlight";
        stringArray[380] = "equal";
        stringArray[381] = "resultingProps";
        stringArray[382] = "should";
        stringArray[383] = "highlight";
        stringArray[384] = "equal";
        stringArray[385] = "resultingProps";
        stringArray[386] = "should";
        stringArray[387] = "highlight";
        stringArray[388] = "equal";
        stringArray[389] = "should";
        stringArray[390] = "title";
        stringArray[391] = "resultingProps";
        stringArray[392] = "equal";
        stringArray[393] = "should";
        stringArray[394] = "title";
        stringArray[395] = "resultingProps";
        stringArray[396] = "equal";
        stringArray[397] = "should";
        stringArray[398] = "title";
        stringArray[399] = "equal";
        stringArray[400] = "should";
        stringArray[401] = "title";
        stringArray[402] = "equal";
        stringArray[403] = "should";
        stringArray[404] = "code";
        stringArray[405] = "throwException";
        stringArray[406] = "should";
        stringArray[407] = "code";
        stringArray[408] = "throwException";
        stringArray[409] = "processAndGetSimplifiedCodeBlock";
        stringArray[410] = "processIncludeAndGetProps";
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[411];
        FileIncludePluginTest.$createCallSiteArray_1(stringArray);
        return new CallSiteArray(FileIncludePluginTest.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = FileIncludePluginTest.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }
}

