/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.footnote;

import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.footnote.FootnoteId;
import org.testingisdocumenting.znai.parser.ParserHandlersList;
import org.testingisdocumenting.znai.parser.commonmark.MarkdownVisitor;
import org.testingisdocumenting.znai.parser.docelement.DocElement;
import org.testingisdocumenting.znai.parser.docelement.DocElementCreationParserHandler;
import org.testingisdocumenting.znai.search.PageSearchEntry;
import org.testingisdocumenting.znai.search.SearchCrawlerParserHandler;
import znaishaded.org.commonmark.ext.footnotes.FootnoteDefinition;
import znaishaded.org.commonmark.node.Node;

public record ParsedFootnote(FootnoteId id, DocElement docElement, List<PageSearchEntry> searchEntries) {
    public static ParsedFootnote parse(ComponentsRegistry componentsRegistry, Path markdownPath, FootnoteDefinition footnote) {
        SearchCrawlerParserHandler searchHandler = new SearchCrawlerParserHandler();
        DocElementCreationParserHandler docElementsHandler = new DocElementCreationParserHandler(componentsRegistry, markdownPath);
        ParserHandlersList parserHandler = new ParserHandlersList(docElementsHandler, searchHandler);
        MarkdownVisitor visitor = new MarkdownVisitor(componentsRegistry, markdownPath, parserHandler);
        ParsedFootnote.visit(visitor, footnote);
        List<PageSearchEntry> searchEntries = searchHandler.getSearchEntries();
        DocElement docElement = docElementsHandler.getDocElement();
        return new ParsedFootnote(new FootnoteId(footnote.getLabel()), docElement, searchEntries);
    }

    private static void visit(MarkdownVisitor visitor, FootnoteDefinition footnote) {
        for (Node node = footnote.getFirstChild(); node != null; node = node.getNext()) {
            node.accept(visitor);
        }
    }

    public String allText() {
        return this.searchEntries.stream().map(PageSearchEntry::extractText).collect(Collectors.joining(" "));
    }
}

