/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.templates;

import java.nio.file.Path;
import java.util.HashMap;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsOpts;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;
import org.testingisdocumenting.znai.template.TextTemplate;
import org.testingisdocumenting.znai.utils.FileUtils;
import org.testingisdocumenting.znai.utils.JsonUtils;

public class TemplateIncludePlugin
implements IncludePlugin {
    private Path fullPath;
    private MarkupParserResult parserResult;
    private ResourcesResolver resourcesResolver;
    private Path paramsPath;

    @Override
    public String id() {
        return "template";
    }

    @Override
    public IncludePlugin create() {
        return new TemplateIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.resourcesResolver = componentsRegistry.resourceResolver();
        MarkupParser parser = componentsRegistry.defaultParser();
        this.fullPath = this.resourcesResolver.fullPath(pluginParams.getFreeParam());
        this.parserResult = parser.parse(markupPath, this.processTemplate(this.resourcesResolver.textContent(this.fullPath), pluginParams.getOpts()));
        return PluginResult.docElements(this.parserResult.docElement().getContent().stream());
    }

    private String processTemplate(String template, PluginParamsOpts opts) {
        HashMap<String, Object> params = new HashMap<String, Object>(opts.toMap());
        if (opts.has("paramsPath")) {
            this.paramsPath = this.resourcesResolver.fullPath((String)opts.get("paramsPath"));
            params.putAll(JsonUtils.deserializeAsMap(FileUtils.fileTextContent(this.paramsPath)));
        }
        return new TextTemplate(this.fullPath.getFileName().toString(), template).process(params);
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        Stream<AuxiliaryFile> files = Stream.concat(this.parserResult.auxiliaryFiles().stream(), Stream.of(AuxiliaryFile.builtTime(this.fullPath)));
        return this.paramsPath != null ? Stream.concat(Stream.of(AuxiliaryFile.builtTime(this.paramsPath)), files) : files;
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.STANDARD.text(this.parserResult.getAllText());
    }
}

