/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.xml;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class XmlPaths {
    private final Set<String> paths = new LinkedHashSet<String>();

    XmlPaths(Map<String, ?> xmlAsJson) {
        this.buildPaths(this.getTagName(xmlAsJson), xmlAsJson);
    }

    public Set<String> getPaths() {
        return this.paths;
    }

    private void buildPaths(String path, Map<String, ?> xmlAsJson) {
        this.paths.add(path);
        this.handleAttributes(path, xmlAsJson);
        this.handleChildren(path, xmlAsJson);
    }

    private void handleChildren(String path, Map<String, ?> xmlAsJson) {
        List<Map<String, ?>> children = this.getChildren(xmlAsJson);
        if (children.size() == 1) {
            String tagName = this.getTagName(children.get(0));
            if (!tagName.isEmpty()) {
                this.buildPaths(path + "." + tagName, children.get(0));
            }
        } else {
            this.buildPathsForChildren(path, children);
        }
    }

    private void handleAttributes(String path, Map<String, ?> xmlAsJson) {
        List<Map<String, ?>> attributes = this.getAttributes(xmlAsJson);
        attributes.forEach(attr -> this.paths.add(path + ".@" + String.valueOf(attr.get("name"))));
    }

    private void buildPathsForChildren(String path, List<Map<String, ?>> children) {
        HashMap<String, Integer> idxByTag = new HashMap<String, Integer>();
        for (Map<String, ?> child : children) {
            String tagName = this.getTagName(child);
            if (tagName.isEmpty()) continue;
            Integer idx = (Integer)idxByTag.get(tagName);
            if (idx == null) {
                idx = 0;
            } else {
                Integer n = idx;
                idx = idx + 1;
            }
            idxByTag.put(tagName, idx);
            this.buildPaths(path + "." + tagName + "[" + idx + "]", child);
        }
    }

    private List<Map<String, ?>> getChildren(Map<String, ?> node) {
        Object children = node.get("children");
        if (children == null) {
            return Collections.emptyList();
        }
        return (List)children;
    }

    private List<Map<String, ?>> getAttributes(Map<String, ?> node) {
        Object children = node.get("attributes");
        if (children == null) {
            return Collections.emptyList();
        }
        return (List)children;
    }

    private String getTagName(Map<String, ?> node) {
        return node.get("tagName").toString();
    }
}

