/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.html.reactjs;

import java.util.Map;
import org.testingisdocumenting.znai.html.HtmlPage;
import org.testingisdocumenting.znai.html.RenderSupplier;
import org.testingisdocumenting.znai.html.reactjs.ReactJsBundle;
import org.testingisdocumenting.znai.utils.JsonUtils;
import org.testingisdocumenting.znai.website.WebResource;
import org.testingisdocumenting.znai.website.WebSiteResourcesProviders;

public class HtmlReactJsPage {
    private static final String REACT_BLOCK_ID = "znai";
    private final ReactJsBundle reactJsBundle;

    public HtmlReactJsPage(ReactJsBundle reactJsBundle) {
        this.reactJsBundle = reactJsBundle;
    }

    public HtmlPage create(String title, String component, Map<String, ?> props, RenderSupplier mainBodySupplier, String favIconCustomPath) {
        HtmlPage htmlPage = new HtmlPage(favIconCustomPath);
        htmlPage.setTitle(title);
        RenderSupplier createElementStatement = () -> "React.createElement(" + component + ", " + JsonUtils.serializePrettyPrint(props) + ")";
        htmlPage.addToBody(() -> "<div id=\"znai\">" + mainBodySupplier.render() + "</div>");
        htmlPage.addToJavaScript(() -> "document.getElementById('znai').innerHTML = '';\n/*<!--*/\nwindow.ReactDOM.render(" + createElementStatement.render() + ", document.getElementById(\"znai\"));\n/*-->*/\n");
        this.reactJsBundle.clientJavaScripts().forEach(htmlPage::addJavaScript);
        this.reactJsBundle.clientCssResources().forEach(htmlPage::addCss);
        WebSiteResourcesProviders.jsResources().forEach(htmlPage::addJavaScript);
        WebSiteResourcesProviders.jsClientOnlyResources().forEach(htmlPage::addJavaScript);
        WebSiteResourcesProviders.cssResources().forEach(htmlPage::addCss);
        WebSiteResourcesProviders.htmlHeadResources().map(WebResource::getTextContent).forEach(text -> htmlPage.addToHead(() -> text));
        WebSiteResourcesProviders.htmlBodyResources().map(WebResource::getTextContent).forEach(text -> htmlPage.addToBody(() -> text));
        return htmlPage;
    }
}

