/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.parser.sphinx.python;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.parser.sphinx.python.PythonFunctionParam;
import org.testingisdocumenting.znai.parser.sphinx.python.PythonFunctionParamSignature;

public class PythonFunction {
    private String refId;
    private String name;
    private String description;
    private List<PythonFunctionParam> params;
    private List<PythonFunctionParamSignature> paramSignatures;

    public PythonFunction(String refId, String name, String description) {
        this.refId = refId;
        this.name = name;
        this.description = description;
        this.params = new ArrayList<PythonFunctionParam>();
        this.paramSignatures = new ArrayList<PythonFunctionParamSignature>();
    }

    public void addParam(PythonFunctionParam param) {
        this.params.add(param);
    }

    public void addParamSignature(PythonFunctionParamSignature paramSignature) {
        this.paramSignatures.add(paramSignature);
    }

    public String getRefId() {
        return this.refId;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public List<PythonFunctionParam> getParams() {
        return this.params;
    }

    public List<PythonFunctionParamSignature> getParamSignatures() {
        return this.paramSignatures;
    }

    public String toString() {
        return "PythonFunction{refId='" + this.refId + "', name='" + this.name + "', description='" + this.description + "', params=" + String.valueOf(this.params) + ", paramSignatures=" + String.valueOf(this.paramSignatures) + "}";
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("refId", this.refId);
        result.put("name", this.name);
        result.put("description", this.description);
        result.put("params", this.params.stream().map(PythonFunctionParam::toMap).collect(Collectors.toList()));
        result.put("paramSignatures", this.paramSignatures.stream().map(PythonFunctionParamSignature::toMap).collect(Collectors.toList()));
        return result;
    }
}

