/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.resources;

import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.resources.ResourcesResolver;

public class UnresolvedResourceException
extends RuntimeException {
    private final String resourceName;

    public UnresolvedResourceException(Stream<ResourcesResolver> resolvers, String resourceName) {
        super("Can't find: " + resourceName + "\n\nTried following ResourceResolvers:\n" + resolvers.map(r -> UnresolvedResourceException.renderResolverDetails(r, resourceName)).collect(Collectors.joining("\n")));
        this.resourceName = resourceName;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    private static String renderResolverDetails(ResourcesResolver resolver, String resourceName) {
        return resolver.getClass().getCanonicalName() + " resources not found:\n  " + String.join((CharSequence)"\n  ", resolver.listOfTriedLocations(resourceName));
    }
}

