/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.draftv4;

import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.github.fge.jackson.JsonNumEquivalence;
import znaishaded.com.github.fge.jackson.NodeType;
import znaishaded.com.github.fge.jackson.jsonpointer.JsonPointer;
import znaishaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.AbstractSyntaxChecker;
import znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import znaishaded.com.github.fge.jsonschema.core.tree.SchemaTree;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;
import znaishaded.com.google.common.base.Equivalence;
import znaishaded.com.google.common.collect.Sets;

public final class DraftV4TypeSyntaxChecker
extends AbstractSyntaxChecker {
    private static final EnumSet<NodeType> ALL_TYPES = EnumSet.allOf(NodeType.class);
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquivalence.getInstance();
    private static final SyntaxChecker INSTANCE = new DraftV4TypeSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private DraftV4TypeSyntaxChecker() {
        super("type", NodeType.ARRAY, NodeType.STRING);
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, MessageBundle bundle, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node = this.getNode(tree);
        if (node.isTextual()) {
            String s2 = node.textValue();
            if (NodeType.fromName(s2) == null) {
                report.error(this.newMsg(tree, bundle, "common.typeDisallow.primitiveType.unknown").putArgument("found", s2).putArgument("valid", ALL_TYPES));
            }
            return;
        }
        int size = node.size();
        if (size == 0) {
            report.error(this.newMsg(tree, bundle, "common.array.empty"));
            return;
        }
        HashSet<Equivalence.Wrapper<JsonNode>> set = Sets.newHashSet();
        boolean uniqueElements = true;
        for (int index = 0; index < size; ++index) {
            JsonNode element = node.get(index);
            NodeType type = NodeType.getNodeType(element);
            uniqueElements = set.add(EQUIVALENCE.wrap(element));
            if (type != NodeType.STRING) {
                report.error(this.newMsg(tree, bundle, "common.array.element.incorrectType").putArgument("index", index).putArgument("expected", NodeType.STRING).putArgument("found", type));
                continue;
            }
            String found = element.textValue();
            if (NodeType.fromName(found) != null) continue;
            report.error(this.newMsg(tree, bundle, "common.typeDisallow.primitiveType.unknown").put("index", index).putArgument("found", found).putArgument("valid", ALL_TYPES));
        }
        if (!uniqueElements) {
            report.error(this.newMsg(tree, bundle, "common.array.duplicateElements"));
        }
    }
}

