/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.google.i18n.phonenumbers.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.com.google.i18n.phonenumbers.Phonemetadata;
import znaishaded.com.google.i18n.phonenumbers.internal.MatcherApi;
import znaishaded.com.google.i18n.phonenumbers.internal.RegexCache;

public final class RegexBasedMatcher
implements MatcherApi {
    private final RegexCache regexCache = new RegexCache(100);

    public static MatcherApi create() {
        return new RegexBasedMatcher();
    }

    private RegexBasedMatcher() {
    }

    @Override
    public boolean matchNationalNumber(CharSequence number, Phonemetadata.PhoneNumberDesc numberDesc, boolean allowPrefixMatch) {
        String nationalNumberPattern = numberDesc.getNationalNumberPattern();
        if (nationalNumberPattern.length() == 0) {
            return false;
        }
        return RegexBasedMatcher.match(number, this.regexCache.getPatternForRegex(nationalNumberPattern), allowPrefixMatch);
    }

    private static boolean match(CharSequence number, Pattern pattern, boolean allowPrefixMatch) {
        Matcher matcher = pattern.matcher(number);
        if (!matcher.lookingAt()) {
            return false;
        }
        return matcher.matches() ? true : allowPrefixMatch;
    }
}

