/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.v3.parser.reference;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import znaishaded.io.swagger.v3.oas.models.Components;
import znaishaded.io.swagger.v3.oas.models.OpenAPI;
import znaishaded.io.swagger.v3.oas.models.Operation;
import znaishaded.io.swagger.v3.oas.models.PathItem;
import znaishaded.io.swagger.v3.oas.models.Paths;
import znaishaded.io.swagger.v3.oas.models.examples.Example;
import znaishaded.io.swagger.v3.oas.models.headers.Header;
import znaishaded.io.swagger.v3.oas.models.links.Link;
import znaishaded.io.swagger.v3.oas.models.media.Encoding;
import znaishaded.io.swagger.v3.oas.models.media.MediaType;
import znaishaded.io.swagger.v3.oas.models.media.Schema;
import znaishaded.io.swagger.v3.oas.models.parameters.Parameter;
import znaishaded.io.swagger.v3.oas.models.parameters.RequestBody;
import znaishaded.io.swagger.v3.oas.models.responses.ApiResponse;
import znaishaded.io.swagger.v3.oas.models.responses.ApiResponses;
import znaishaded.io.swagger.v3.oas.models.security.SecurityScheme;
import znaishaded.io.swagger.v3.parser.core.models.AuthorizationValue;
import znaishaded.io.swagger.v3.parser.util.ClasspathHelper;
import znaishaded.io.swagger.v3.parser.util.RemoteUrl;
import znaishaded.org.apache.commons.io.IOUtils;
import znaishaded.org.apache.commons.lang3.StringUtils;

public interface Visitor {
    public OpenAPI visitOpenApi(OpenAPI var1);

    public Paths visitPaths(Paths var1);

    public Components visitComponents(Components var1);

    public PathItem visitPathItem(PathItem var1);

    public Parameter visitParameter(Parameter var1);

    public Operation visitOperation(Operation var1);

    public Schema visitSchema(Schema var1, List<String> var2);

    public ApiResponse visitResponse(ApiResponse var1);

    public RequestBody visitRequestBody(RequestBody var1);

    public Link visitLink(Link var1);

    public SecurityScheme visitSecurityScheme(SecurityScheme var1);

    public ApiResponses visitResponses(ApiResponses var1);

    public MediaType visitMediaType(MediaType var1);

    public Encoding visitEncoding(Encoding var1);

    public Header visitHeader(Header var1);

    public Example visitExample(Example var1);

    default public String readFile(String path) throws Exception {
        try (FileInputStream inputStream = new FileInputStream(path);){
            String string = IOUtils.toString((InputStream)inputStream, StandardCharsets.UTF_8);
            return string;
        }
    }

    default public String readClasspath(String classPath) throws Exception {
        return ClasspathHelper.loadFileFromClasspath(classPath);
    }

    default public String readHttp(String uri, List<AuthorizationValue> auths) throws Exception {
        return RemoteUrl.urlToString(uri, auths);
    }

    default public String readURI(String absoluteUri, List<AuthorizationValue> auths) throws Exception {
        URI resolved = new URI(absoluteUri);
        if (StringUtils.isNotBlank(resolved.getScheme())) {
            if (resolved.getScheme().startsWith("http")) {
                return this.readHttp(absoluteUri, auths);
            }
            if (resolved.getScheme().startsWith("file")) {
                return this.readFile(resolved.getPath());
            }
            if (resolved.getScheme().startsWith("classpath")) {
                return this.readClasspath(resolved.getPath());
            }
        }
        String content = null;
        try {
            content = this.readFile(absoluteUri);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isBlank(content)) {
            content = this.readClasspath(absoluteUri);
        }
        return content;
    }
}

