/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.http.impl;

import znaishaded.io.vertx.core.http.WebSocket;
import znaishaded.io.vertx.core.http.impl.Http1xClientConnection;
import znaishaded.io.vertx.core.http.impl.Http1xConnectionBase;
import znaishaded.io.vertx.core.http.impl.WebSocketImplBase;
import znaishaded.io.vertx.core.spi.metrics.HttpClientMetrics;

public class WebSocketImpl
extends WebSocketImplBase<WebSocketImpl>
implements WebSocket {
    private long timerID = -1L;
    private final long closingTimeoutMS;

    public WebSocketImpl(Http1xClientConnection conn, boolean supportsContinuation, long closingTimeout, int maxWebSocketFrameSize, int maxWebSocketMessageSize) {
        super(conn, supportsContinuation, maxWebSocketFrameSize, maxWebSocketMessageSize);
        this.closingTimeoutMS = closingTimeout > 0L ? closingTimeout * 1000L : 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void handleClosed() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            HttpClientMetrics metrics;
            if (this.timerID != -1L) {
                this.conn.getContext().owner().cancelTimer(this.timerID);
            }
            if ((metrics = ((Http1xClientConnection)this.conn).metrics()) != null) {
                metrics.disconnected(this.getMetric());
            }
        }
        super.handleClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() {
        Http1xConnectionBase http1xConnectionBase = this.conn;
        synchronized (http1xConnectionBase) {
            if (this.closingTimeoutMS > 0L) {
                this.timerID = this.conn.getContext().owner().setTimer(this.closingTimeoutMS, id -> {
                    Http1xConnectionBase http1xConnectionBase = this.conn;
                    synchronized (http1xConnectionBase) {
                        this.timerID = -1L;
                    }
                    this.conn.channelHandlerContext().close();
                });
            }
        }
    }
}

