/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.handler.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.http.HttpHeaders;
import znaishaded.io.vertx.core.http.HttpMethod;
import znaishaded.io.vertx.core.http.HttpServerRequest;
import znaishaded.io.vertx.core.json.JsonObject;
import znaishaded.io.vertx.ext.auth.AuthProvider;
import znaishaded.io.vertx.ext.auth.User;
import znaishaded.io.vertx.ext.web.RoutingContext;
import znaishaded.io.vertx.ext.web.Session;
import znaishaded.io.vertx.ext.web.handler.AuthHandler;
import znaishaded.io.vertx.ext.web.handler.impl.HttpStatusException;

public abstract class AuthHandlerImpl
implements AuthHandler {
    static final String AUTH_PROVIDER_CONTEXT_KEY = "znaishaded.io.vertx.ext.web.handler.AuthHandler.provider";
    static final HttpStatusException FORBIDDEN = new HttpStatusException(403);
    static final HttpStatusException UNAUTHORIZED = new HttpStatusException(401);
    static final HttpStatusException BAD_REQUEST = new HttpStatusException(400);
    protected final String realm;
    protected final AuthProvider authProvider;
    protected final Set<String> authorities = new HashSet<String>();

    public AuthHandlerImpl(AuthProvider authProvider) {
        this(authProvider, "");
    }

    public AuthHandlerImpl(AuthProvider authProvider, String realm) {
        this.authProvider = authProvider;
        this.realm = realm;
    }

    @Override
    public AuthHandler addAuthority(String authority) {
        this.authorities.add(authority);
        return this;
    }

    @Override
    public AuthHandler addAuthorities(Set<String> authorities) {
        this.authorities.addAll(authorities);
        return this;
    }

    @Override
    public void authorize(User user, Handler<AsyncResult<Void>> handler) {
        int requiredcount = this.authorities.size();
        if (requiredcount > 0) {
            if (user == null) {
                handler.handle(Future.failedFuture(FORBIDDEN));
                return;
            }
            AtomicInteger count = new AtomicInteger();
            AtomicBoolean sentFailure = new AtomicBoolean();
            Handler<AsyncResult<Boolean>> authHandler = res -> {
                if (res.succeeded()) {
                    if (((Boolean)res.result()).booleanValue()) {
                        if (count.incrementAndGet() == requiredcount) {
                            handler.handle(Future.succeededFuture());
                        }
                    } else if (sentFailure.compareAndSet(false, true)) {
                        handler.handle(Future.failedFuture(FORBIDDEN));
                    }
                } else {
                    handler.handle(Future.failedFuture(res.cause()));
                }
            };
            for (String authority : this.authorities) {
                if (sentFailure.get()) continue;
                user.isAuthorized(authority, authHandler);
            }
        } else {
            handler.handle(Future.succeededFuture());
        }
    }

    protected String authenticateHeader(RoutingContext context) {
        return null;
    }

    @Override
    public void handle(RoutingContext ctx) {
        if (this.handlePreflight(ctx)) {
            return;
        }
        User user = ctx.user();
        if (user != null) {
            this.authorizeUser(ctx, user);
            return;
        }
        this.parseCredentials(ctx, res -> {
            if (res.failed()) {
                this.processException(ctx, res.cause());
                return;
            }
            User updatedUser = ctx.user();
            if (updatedUser != null) {
                Session session = ctx.session();
                if (session != null) {
                    session.regenerateId();
                }
                this.authorizeUser(ctx, updatedUser);
                return;
            }
            this.getAuthProvider(ctx).authenticate((JsonObject)res.result(), authN -> {
                if (authN.succeeded()) {
                    User authenticated = (User)authN.result();
                    ctx.setUser(authenticated);
                    Session session = ctx.session();
                    if (session != null) {
                        session.regenerateId();
                    }
                    this.authorizeUser(ctx, authenticated);
                } else {
                    String header = this.authenticateHeader(ctx);
                    if (header != null) {
                        ctx.response().putHeader("WWW-Authenticate", header);
                    }
                    if (authN.cause() instanceof HttpStatusException) {
                        this.processException(ctx, authN.cause());
                    } else {
                        this.processException(ctx, new HttpStatusException(401, authN.cause()));
                    }
                }
            });
        });
    }

    protected void processException(RoutingContext ctx, Throwable exception) {
        if (exception != null && exception instanceof HttpStatusException) {
            int statusCode = ((HttpStatusException)exception).getStatusCode();
            String payload = ((HttpStatusException)exception).getPayload();
            switch (statusCode) {
                case 302: {
                    ctx.response().putHeader(HttpHeaders.LOCATION, (CharSequence)payload).setStatusCode(302).end("Redirecting to " + payload + ".");
                    return;
                }
                case 401: {
                    String header = this.authenticateHeader(ctx);
                    if (header != null) {
                        ctx.response().putHeader("WWW-Authenticate", header);
                    }
                    ctx.fail(401, exception);
                    return;
                }
            }
            ctx.fail(statusCode, exception);
            return;
        }
        ctx.fail(exception);
    }

    private void authorizeUser(RoutingContext ctx, User user) {
        this.authorize(user, authZ -> {
            if (authZ.failed()) {
                this.processException(ctx, authZ.cause());
                return;
            }
            ctx.next();
        });
    }

    private boolean handlePreflight(RoutingContext ctx) {
        String accessControlRequestHeader;
        HttpServerRequest request = ctx.request();
        if (request.method() == HttpMethod.OPTIONS && (accessControlRequestHeader = ctx.request().getHeader(HttpHeaders.ACCESS_CONTROL_REQUEST_HEADERS)) != null) {
            for (String ctrlReq : accessControlRequestHeader.split(",")) {
                if (!ctrlReq.equalsIgnoreCase("Authorization")) continue;
                ctx.next();
                return true;
            }
        }
        return false;
    }

    private AuthProvider getAuthProvider(RoutingContext ctx) {
        try {
            AuthProvider provider = (AuthProvider)ctx.get(AUTH_PROVIDER_CONTEXT_KEY);
            if (provider != null) {
                return provider;
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return this.authProvider;
    }
}

