/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.handler.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.json.JsonObject;
import znaishaded.io.vertx.ext.web.RoutingContext;
import znaishaded.io.vertx.ext.web.handler.AuthHandler;
import znaishaded.io.vertx.ext.web.handler.ChainAuthHandler;
import znaishaded.io.vertx.ext.web.handler.impl.AuthHandlerImpl;
import znaishaded.io.vertx.ext.web.handler.impl.HttpStatusException;

public class ChainAuthHandlerImpl
extends AuthHandlerImpl
implements ChainAuthHandler {
    private final List<AuthHandler> handlers = new ArrayList<AuthHandler>();

    public ChainAuthHandlerImpl() {
        super(null);
    }

    @Override
    public ChainAuthHandler append(AuthHandler other) {
        this.handlers.add(other);
        return this;
    }

    @Override
    public boolean remove(AuthHandler other) {
        return this.handlers.remove(other);
    }

    @Override
    public void clear() {
        this.handlers.clear();
    }

    @Override
    public AuthHandler addAuthority(String authority) {
        for (AuthHandler h2 : this.handlers) {
            h2.addAuthority(authority);
        }
        return this;
    }

    @Override
    public AuthHandler addAuthorities(Set<String> authorities) {
        for (AuthHandler h2 : this.handlers) {
            h2.addAuthorities(authorities);
        }
        return this;
    }

    @Override
    public void parseCredentials(RoutingContext context, Handler<AsyncResult<JsonObject>> handler) {
        this.iterate(0, context, null, handler);
    }

    private void iterate(int idx, RoutingContext ctx, HttpStatusException lastException, Handler<AsyncResult<JsonObject>> handler) {
        if (idx >= this.handlers.size()) {
            handler.handle(Future.failedFuture(lastException));
            return;
        }
        AuthHandler authHandler = this.handlers.get(idx);
        authHandler.parseCredentials(ctx, res -> {
            if (res.failed()) {
                if (res.cause() instanceof HttpStatusException) {
                    HttpStatusException exception = (HttpStatusException)res.cause();
                    switch (exception.getStatusCode()) {
                        case 302: 
                        case 400: 
                        case 401: 
                        case 403: {
                            this.iterate(idx + 1, ctx, exception, handler);
                            return;
                        }
                    }
                }
                handler.handle(Future.failedFuture(res.cause()));
                return;
            }
            if (authHandler instanceof AuthHandlerImpl) {
                ctx.put("znaishaded.io.vertx.ext.web.handler.AuthHandler.provider", ((AuthHandlerImpl)authHandler).authProvider);
            }
            handler.handle(Future.succeededFuture(res.result()));
        });
    }
}

