/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.AbstractInstruction;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.Instruction;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.InstructionList;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.PositionedNote;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileKilled;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlanes;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.GtileBox;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.GtileRepeat;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.klimt.color.Colors;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NoteType;
import znaishaded.net.sourceforge.plantuml.stereo.Stereotype;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;

public class InstructionRepeat
extends AbstractInstruction
implements Instruction {
    private final InstructionList repeatList;
    private final Instruction parent;
    private final LinkRendering nextLinkRenderer;
    private final Swimlane swimlane;
    private final Swimlanes swimlanes;
    private Swimlane swimlaneOut;
    private Swimlane swimlaneBackward;
    private BoxStyle boxStyle;
    private boolean killed = false;
    private final BoxStyle boxStyleIn;
    private Display backward = Display.NULL;
    private Stereotype stereotype;
    private LinkRendering incoming1 = LinkRendering.none();
    private LinkRendering incoming2 = LinkRendering.none();
    private List<PositionedNote> backwardNotes = new ArrayList<PositionedNote>();
    private Display test = Display.NULL;
    private Display yes = Display.NULL;
    private Display out = Display.NULL;
    private final Display startLabel;
    private boolean testCalled = false;
    private LinkRendering endRepeatLinkRendering = LinkRendering.none();
    private final Colors colors;

    @Override
    public boolean containsBreak() {
        return this.repeatList.containsBreak();
    }

    public InstructionRepeat(Swimlanes swimlanes, Instruction parent, LinkRendering nextLinkRenderer, HColor color, Display startLabel, BoxStyle boxStyleIn, Colors colors) {
        this.swimlanes = swimlanes;
        this.swimlane = swimlanes.getCurrentSwimlane();
        this.repeatList = new InstructionList(this.swimlane);
        this.boxStyleIn = boxStyleIn;
        this.startLabel = startLabel;
        this.parent = parent;
        this.nextLinkRenderer = Objects.requireNonNull(nextLinkRenderer);
        this.colors = colors;
    }

    private boolean isLastOfTheParent() {
        if (this.parent instanceof InstructionList) {
            return ((InstructionList)this.parent).getLast() == this;
        }
        return false;
    }

    public void setBackward(Display label, Swimlane swimlaneBackward, BoxStyle boxStyle, LinkRendering incoming1, LinkRendering incoming2, Stereotype stereotype) {
        this.backward = label;
        this.swimlaneBackward = swimlaneBackward;
        this.boxStyle = boxStyle;
        this.incoming1 = incoming1;
        this.incoming2 = incoming2;
        this.stereotype = stereotype;
    }

    public boolean hasBackward() {
        return this.backward != Display.NULL;
    }

    @Override
    public CommandExecutionResult add(Instruction ins) {
        return this.repeatList.add(ins);
    }

    @Override
    public Gtile createGtile(ISkinParam skinParam, StringBounder stringBounder) {
        Gtile tile = this.repeatList.createGtile(skinParam, stringBounder);
        Gtile backward = this.getGtileBackward(skinParam, stringBounder);
        return new GtileRepeat(this.swimlane, tile, null, this.test, backward);
    }

    private Gtile getGtileBackward(ISkinParam skinParam, StringBounder stringBounder) {
        if (Display.isNull(this.backward)) {
            return null;
        }
        GtileBox result = GtileBox.create(stringBounder, skinParam, this.backward, this.getSwimlaneIn(), this.boxStyle, null);
        return result;
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        Ftile back = this.getFtileBackward(factory);
        Ftile decorateOut = factory.decorateOut(this.repeatList.createFtile(factory), this.endRepeatLinkRendering);
        if (!this.testCalled && this.incoming1.isNone()) {
            this.incoming1 = this.swimlanes.nextLinkRenderer();
        }
        Ftile result = factory.repeat(this.boxStyleIn, this.swimlane, this.swimlaneOut, this.startLabel, decorateOut, this.test, this.yes, this.out, this.colors, back, this.isLastOfTheParent(), this.incoming1, this.incoming2);
        if (this.killed) {
            return new FtileKilled(result);
        }
        return result;
    }

    private Ftile getFtileBackward(FtileFactory factory) {
        if (Display.isNull(this.backward)) {
            return null;
        }
        Ftile result = factory.activity(this.backward, this.swimlaneBackward, this.boxStyle, Colors.empty(), this.stereotype);
        if (this.backwardNotes.size() > 0) {
            result = factory.addNote(result, this.swimlaneBackward, this.backwardNotes, VerticalAlignment.CENTER);
        }
        return result;
    }

    public Instruction getParent() {
        return this.parent;
    }

    public void setTest(Display test2, Display yes, Display out, LinkRendering endRepeatLinkRendering, LinkRendering back, Swimlane swimlaneOut) {
        this.swimlaneOut = swimlaneOut;
        this.test = Objects.requireNonNull(test2);
        this.yes = Objects.requireNonNull(yes);
        this.out = Objects.requireNonNull(out);
        this.endRepeatLinkRendering = endRepeatLinkRendering;
        if (!back.isNone()) {
            this.incoming1 = back;
        }
        this.testCalled = true;
    }

    @Override
    public final boolean kill() {
        if (this.testCalled) {
            this.killed = true;
            return true;
        }
        return this.repeatList.kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.nextLinkRenderer;
    }

    @Override
    public boolean addNote(Display note, NotePosition position, NoteType type, Colors colors, Swimlane swimlaneNote) {
        if (Display.isNull(this.backward)) {
            return this.repeatList.addNote(note, position, type, colors, swimlaneNote);
        }
        this.backwardNotes.add(new PositionedNote(note, position, type, swimlaneNote, colors));
        return true;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.repeatList.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.parent.getSwimlaneOut();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.parent.getSwimlaneOut();
    }
}

