/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.AbstractInstruction;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ForkStyle;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.Instruction;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.InstructionList;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.GtileSplit;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.gtile.Gtiles;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.decoration.Rainbow;
import znaishaded.net.sourceforge.plantuml.klimt.color.Colors;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NotePosition;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NoteType;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;

public class InstructionSplit
extends AbstractInstruction
implements Instruction {
    private final List<InstructionList> splits = new ArrayList<InstructionList>();
    private final Instruction parent;
    private final LinkRendering inlinkRendering;
    private final Swimlane swimlaneIn;
    private Swimlane swimlaneOut;

    public InstructionSplit(Instruction parent, LinkRendering inlinkRendering, Swimlane swimlane) {
        this.parent = parent;
        this.swimlaneIn = swimlane;
        this.splits.add(new InstructionList(swimlane));
        this.inlinkRendering = Objects.requireNonNull(inlinkRendering);
    }

    @Override
    public boolean containsBreak() {
        for (InstructionList split : this.splits) {
            if (!split.containsBreak()) continue;
            return true;
        }
        return false;
    }

    private InstructionList getLast() {
        return this.splits.get(this.splits.size() - 1);
    }

    @Override
    public CommandExecutionResult add(Instruction ins) {
        return this.getLast().add(ins);
    }

    @Override
    public Gtile createGtile(ISkinParam skinParam, StringBounder stringBounder) {
        ArrayList<Gtile> all = new ArrayList<Gtile>();
        for (InstructionList list : this.splits) {
            Gtile tmp = list.createGtile(skinParam, stringBounder);
            tmp = Gtiles.withIncomingArrow(tmp, 20.0);
            tmp = Gtiles.withOutgoingArrow(tmp, 20.0);
            all.add(tmp);
        }
        return new GtileSplit(all, this.swimlaneIn, this.getInLinkRenderingColor(skinParam).getColor());
    }

    private Rainbow getInLinkRenderingColor(ISkinParam skinParam) {
        Rainbow color = Rainbow.build(skinParam);
        return color;
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        ArrayList<Ftile> all = new ArrayList<Ftile>();
        for (InstructionList list : this.splits) {
            all.add(list.createFtile(factory));
        }
        return factory.createParallel(all, ForkStyle.SPLIT, null, this.swimlaneIn, this.swimlaneOut);
    }

    public Instruction getParent() {
        return this.parent;
    }

    public void splitAgain(LinkRendering inlinkRendering) {
        if (inlinkRendering != null) {
            this.getLast().setOutRendering(inlinkRendering);
        }
        InstructionList list = new InstructionList(this.swimlaneIn);
        this.splits.add(list);
    }

    public void endSplit(LinkRendering inlinkRendering, Swimlane endSwimlane) {
        if (inlinkRendering != null) {
            this.getLast().setOutRendering(inlinkRendering);
        }
        this.swimlaneOut = endSwimlane;
    }

    @Override
    public final boolean kill() {
        return this.getLast().kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.inlinkRendering;
    }

    @Override
    public boolean addNote(Display note, NotePosition position, NoteType type, Colors colors, Swimlane swimlaneNote) {
        return this.getLast().addNote(note, position, type, colors, swimlaneNote);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return InstructionList.getSwimlanes2(this.splits);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.parent.getSwimlaneOut();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlaneOut;
    }
}

