/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.braille;

import java.io.IOException;
import java.io.OutputStream;
import znaishaded.net.atmp.ImageBuilder;
import znaishaded.net.sourceforge.plantuml.braille.BrailleDrawer;
import znaishaded.net.sourceforge.plantuml.braille.BrailleGrid;
import znaishaded.net.sourceforge.plantuml.braille.DriverCenteredCharacterBraille;
import znaishaded.net.sourceforge.plantuml.braille.DriverDotPathBraille;
import znaishaded.net.sourceforge.plantuml.braille.DriverLineBraille;
import znaishaded.net.sourceforge.plantuml.braille.DriverPolygonBraille;
import znaishaded.net.sourceforge.plantuml.braille.DriverRectangleBraille;
import znaishaded.net.sourceforge.plantuml.braille.DriverTextBraille;
import znaishaded.net.sourceforge.plantuml.klimt.ClipContainer;
import znaishaded.net.sourceforge.plantuml.klimt.UPath;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.AbstractCommonUGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.AbstractUGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.shape.DotPath;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UCenteredCharacter;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UEllipse;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UImage;
import znaishaded.net.sourceforge.plantuml.klimt.shape.ULine;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UPolygon;
import znaishaded.net.sourceforge.plantuml.klimt.shape.URectangle;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UText;

public class UGraphicBraille
extends AbstractUGraphic<BrailleGrid>
implements ClipContainer {
    public static final int QUANTA = 4;

    @Override
    protected AbstractCommonUGraphic copyUGraphic() {
        UGraphicBraille result = new UGraphicBraille(this);
        return result;
    }

    public UGraphicBraille(HColor defaultBackground, ColorMapper colorMapper, StringBounder stringBounder) {
        super(stringBounder);
        this.copy(defaultBackground, colorMapper, new BrailleGrid(4.0));
        this.register();
    }

    private UGraphicBraille(UGraphicBraille other) {
        super(other.getStringBounder());
        this.copy(other);
        this.register();
    }

    private void register() {
        this.ignoreShape(URectangle.class);
        this.registerDriver(URectangle.class, new DriverRectangleBraille(this));
        this.registerDriver(UText.class, new DriverTextBraille());
        this.registerDriver(ULine.class, new DriverLineBraille(this));
        this.registerDriver(UPolygon.class, new DriverPolygonBraille(this));
        this.ignoreShape(UEllipse.class);
        this.ignoreShape(UImage.class);
        this.ignoreShape(UPath.class);
        this.registerDriver(DotPath.class, new DriverDotPathBraille());
        this.registerDriver(UCenteredCharacter.class, new DriverCenteredCharacterBraille());
    }

    @Override
    public void writeToStream(OutputStream os, String metadata, int dpi) throws IOException {
        ImageBuilder.plainPngBuilder(new BrailleDrawer((BrailleGrid)this.getGraphicObject())).metadata(metadata).write(os);
    }
}

