/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.descdiagram;

import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorType;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontParam;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.PlacementStrategyY1Y2;
import znaishaded.net.sourceforge.plantuml.klimt.geom.ULayoutGroup;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.klimt.shape.URectangle;
import znaishaded.net.sourceforge.plantuml.skin.ColorParam;
import znaishaded.net.sourceforge.plantuml.skin.LineParam;
import znaishaded.net.sourceforge.plantuml.skin.SkinParamUtils;
import znaishaded.net.sourceforge.plantuml.stereo.Stereotype;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.text.Guillemet;
import znaishaded.net.sourceforge.plantuml.url.Url;

public class EntityImageMachine
extends AbstractEntityImage {
    private final TextBlock name;
    private final TextBlock stereo;
    private final Url url;

    public EntityImageMachine(Entity entity, ISkinParam skinParam) {
        super(entity, skinParam);
        Stereotype stereotype = entity.getStereotype();
        this.name = TextBlockUtils.withMargin(entity.getDisplay().create(FontConfiguration.create(this.getSkinParam(), FontParam.MACHINE, stereotype), HorizontalAlignment.CENTER, skinParam), 2.0, 2.0);
        this.stereo = stereotype == null || stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR) == null ? null : Display.create(stereotype.getLabels(skinParam.guillemet())).create(FontConfiguration.create(this.getSkinParam(), FontParam.MACHINE_STEREOTYPE, stereotype), HorizontalAlignment.CENTER, skinParam);
        this.url = entity.getUrl99();
    }

    private UStroke getStroke() {
        UStroke stroke = this.getSkinParam().getThickness(LineParam.machineBorder, this.getStereo());
        if (stroke == null) {
            stroke = UStroke.withThickness(1.5);
        }
        return stroke;
    }

    private XDimension2D getTitleDimension(StringBounder stringBounder) {
        return this.getNameAndSteretypeDimension(stringBounder);
    }

    private XDimension2D getNameAndSteretypeDimension(StringBounder stringBounder) {
        XDimension2D nameDim = this.name.calculateDimension(stringBounder);
        XDimension2D stereoDim = this.stereo == null ? new XDimension2D(0.0, 0.0) : this.stereo.calculateDimension(stringBounder);
        XDimension2D nameAndStereo = new XDimension2D(Math.max(nameDim.getWidth(), stereoDim.getWidth()), nameDim.getHeight() + stereoDim.getHeight());
        return nameAndStereo;
    }

    public double getStartingX(StringBounder stringBounder, double y) {
        return 0.0;
    }

    public double getEndingX(StringBounder stringBounder, double y) {
        return this.calculateDimension(stringBounder).getWidth();
    }

    @Override
    public final void drawU(UGraphic ug) {
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dimTotal = this.calculateDimension(stringBounder);
        XDimension2D dimTitle = this.getTitleDimension(stringBounder);
        double widthTotal = dimTotal.getWidth();
        double heightTotal = dimTotal.getHeight();
        URectangle rect = URectangle.build(widthTotal, heightTotal);
        URectangle rect2 = URectangle.build(4.0, heightTotal);
        ug = ug.apply(SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.machineBorder));
        HColor backcolor = this.getEntity().getColors().getColor(ColorType.BACK);
        if (backcolor == null) {
            backcolor = SkinParamUtils.getColor(this.getSkinParam(), this.getStereo(), ColorParam.machineBackground);
        }
        ug = ug.apply(backcolor.bg());
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        UStroke stroke = this.getStroke();
        ug.apply(stroke).draw(rect);
        ug.apply(UTranslate.dx(4.0)).apply(stroke).draw(rect2);
        ULayoutGroup header = new ULayoutGroup(new PlacementStrategyY1Y2(ug.getStringBounder()));
        header.add(this.name);
        header.drawU(ug.apply(UTranslate.dx(5.0)), dimTotal.getWidth(), dimTitle.getHeight());
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D dimTitle = this.getTitleDimension(stringBounder);
        double width = dimTitle.getWidth();
        double height = dimTitle.getHeight();
        return new XDimension2D(width + 10.0, height);
    }
}

