/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.help;

import java.io.IOException;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.help.Help;
import znaishaded.net.sourceforge.plantuml.log.Logme;
import znaishaded.net.sourceforge.plantuml.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.theme.ThemeUtils;
import znaishaded.net.sourceforge.plantuml.utils.LineLocation;
import znaishaded.net.sourceforge.plantuml.utils.Log;

public class CommandHelpTheme
extends SingleLineCommand2<Help> {
    public CommandHelpTheme() {
        super(CommandHelpTheme.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandHelpTheme.class.getName(), RegexLeaf.start(), new RegexLeaf("help"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("themes?"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(Help diagram, LineLocation location, RegexResult arg) {
        diagram.add("<b>Help on themes");
        diagram.add(" ");
        diagram.add(" The possible themes are :");
        try {
            for (String theme : ThemeUtils.getAllThemeNames()) {
                diagram.add("* " + theme);
            }
        }
        catch (IOException e) {
            String message = "Unexpected error listing themes: " + e.getMessage();
            Log.error(message);
            Logme.error(e);
            return CommandExecutionResult.error(message);
        }
        return CommandExecutionResult.ok();
    }
}

