/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XCubicCurve2D;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XPoint2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.DotPath;

public class UMotif {
    private final List<XPoint2D> points = new ArrayList<XPoint2D>();

    public UMotif(int ... data) {
        assert (data.length % 2 == 0);
        for (int i = 0; i < data.length; i += 2) {
            this.points.add(new XPoint2D(data[i], data[i + 1]));
        }
    }

    public UMotif(String s2) {
        XPoint2D last = new XPoint2D(0.0, 0.0);
        for (int i = 0; i < s2.length(); ++i) {
            XPoint2D read = UMotif.convertPoint(s2.charAt(i));
            last = last.move(read);
            this.points.add(last);
        }
    }

    public double getLength() {
        return this.points.get(0).distance(this.points.get(this.points.size() - 1));
    }

    List<XPoint2D> getPoints() {
        return Collections.unmodifiableList(this.points);
    }

    public DotPath getRectangle(double width, double height) {
        double len = this.getLength();
        int nb1 = (int)(width / len);
        DotPath h1 = this.drawHorizontal(0.0, 0.0, nb1);
        int nb2 = (int)(height / len);
        DotPath v1 = this.drawVertical(h1.getEndPoint().getX(), h1.getEndPoint().getY(), nb2);
        h1 = h1.addAfter(v1);
        return h1;
    }

    public static XPoint2D convertPoint(char c) {
        int v = UMotif.convertFromChar(c);
        int x = v % 7;
        int y = v / 7;
        return new XPoint2D(x - 3, y - 3);
    }

    public static int convertFromChar(char c) {
        if (c >= 'A' && c <= 'Z') {
            return c - 65;
        }
        if (c >= 'a' && c <= 'w') {
            return c - 97 + 26;
        }
        throw new IllegalArgumentException();
    }

    public void drawHorizontal(UGraphic ug, double x, double y, int nb) {
        DotPath path = this.drawHorizontal(x, y, nb);
        ug.draw(path);
    }

    public void drawVertical(UGraphic ug, double x, double y, int nb) {
        DotPath path = this.drawVertical(x, y, nb);
        ug.draw(path);
    }

    DotPath drawHorizontal(double x, double y, int nb) {
        DotPath path = new DotPath();
        for (int i = 0; i < nb; ++i) {
            path = this.addHorizontal(x, y, path);
            x = path.getEndPoint().getX();
            y = path.getEndPoint().getY();
        }
        return path;
    }

    DotPath drawVertical(double x, double y, int nb) {
        DotPath path = new DotPath();
        for (int i = 0; i < nb; ++i) {
            path = this.addVertical(x, y, path);
            x = path.getEndPoint().getX();
            y = path.getEndPoint().getY();
        }
        return path;
    }

    private DotPath addHorizontal(double x, double y, DotPath path) {
        double lastx = 0.0;
        double lasty = 0.0;
        for (XPoint2D p : this.points) {
            double x1 = lastx + x;
            double y1 = lasty + y;
            double x2 = p.getX() + x;
            double y2 = p.getY() + y;
            path = path.addAfter(new XCubicCurve2D(x1, y1, x1, y1, x2, y2, x2, y2));
            lastx = p.getX();
            lasty = p.getY();
        }
        return path;
    }

    private DotPath addVertical(double x, double y, DotPath path) {
        double lastx = 0.0;
        double lasty = 0.0;
        for (XPoint2D p : this.points) {
            double x1 = lastx + x;
            double y1 = lasty + y;
            double x2 = p.getY() + x;
            double y2 = p.getX() + y;
            path = path.addAfter(new XCubicCurve2D(x1, y1, x1, y1, x2, y2, x2, y2));
            lastx = p.getY();
            lasty = p.getX();
        }
        return path;
    }
}

