/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.klimt.shape;

import znaishaded.net.atmp.InnerStrategy;
import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.LimitFinder;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.MagneticBorder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.MinMax;
import znaishaded.net.sourceforge.plantuml.klimt.geom.Positionable;
import znaishaded.net.sourceforge.plantuml.klimt.geom.PositionableImpl;
import znaishaded.net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XPoint2D;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XRectangle2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlockBordered;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlockHorizontal;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlockMarged;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlockMinWidth;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlockVertical2;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UDrawable;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UImage;
import znaishaded.net.sourceforge.plantuml.style.ClockwiseTopRightBottomLeft;

public class TextBlockUtils {
    public static final TextBlock EMPTY_TEXT_BLOCK = TextBlockUtils.empty(0.0, 0.0);

    public static TextBlock bordered(TextBlock textBlock, UStroke stroke, HColor borderColor, HColor backgroundColor, double cornersize, ClockwiseTopRightBottomLeft margins, String id) {
        return new TextBlockBordered(textBlock, stroke, borderColor, backgroundColor, cornersize, margins, id);
    }

    public static TextBlock withMargin(TextBlock textBlock, double marginX, double marginY) {
        if (marginX == 0.0 && marginY == 0.0) {
            return textBlock;
        }
        return new TextBlockMarged(textBlock, marginY, marginX, marginY, marginX);
    }

    public static TextBlock withMargin(TextBlock textBlock, ClockwiseTopRightBottomLeft margins) {
        return new TextBlockMarged(textBlock, margins);
    }

    public static TextBlock withMargin(TextBlock textBlock, double marginX1, double marginX2, double marginY1, double marginY2) {
        return new TextBlockMarged(textBlock, marginY1, marginX2, marginY2, marginX1);
    }

    public static TextBlock withMinWidth(TextBlock textBlock, double minWidth, HorizontalAlignment horizontalAlignment) {
        return new TextBlockMinWidth(textBlock, minWidth, horizontalAlignment);
    }

    public static TextBlock empty(final double width, final double height) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D(width, height);
            }

            @Override
            public XRectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                return null;
            }
        };
    }

    public static Positionable asPositionable(TextBlock textBlock, StringBounder stringBounder, XPoint2D pt) {
        return PositionableImpl.create(pt, textBlock.calculateDimension(stringBounder));
    }

    public static Positionable asPositionable(XDimension2D dim, StringBounder stringBounder, XPoint2D pt) {
        return PositionableImpl.create(pt, dim);
    }

    public static TextBlock mergeLR(TextBlock b1, TextBlock b2, VerticalAlignment verticallAlignment) {
        if (b1 == EMPTY_TEXT_BLOCK) {
            return b2;
        }
        if (b2 == EMPTY_TEXT_BLOCK) {
            return b1;
        }
        return new TextBlockHorizontal(b1, b2, verticallAlignment);
    }

    public static TextBlock mergeTB(TextBlock b1, TextBlock b2, HorizontalAlignment horizontalAlignment) {
        if (b1 == EMPTY_TEXT_BLOCK) {
            return b2;
        }
        if (b2 == EMPTY_TEXT_BLOCK) {
            return b1;
        }
        return new TextBlockVertical2(b1, b2, horizontalAlignment);
    }

    public static TextBlock mergeTB(TextBlock b1, UImage image, HorizontalAlignment horizontalAlignment) {
        if (b1 == EMPTY_TEXT_BLOCK) {
            throw new IllegalArgumentException();
        }
        return new TextBlockVertical2(b1, image, horizontalAlignment);
    }

    public static MinMax getMinMax(UDrawable tb, StringBounder stringBounder, boolean initToZero) {
        LimitFinder limitFinder = LimitFinder.create(stringBounder, initToZero);
        tb.drawU(limitFinder);
        return limitFinder.getMinMax();
    }

    public static boolean isEmpty(TextBlock text, StringBounder dummyStringBounder) {
        if (text == null || text == EMPTY_TEXT_BLOCK) {
            return true;
        }
        XDimension2D dim = text.calculateDimension(dummyStringBounder);
        return dim.getHeight() == 0.0 && dim.getWidth() == 0.0;
    }

    public static TextBlock fullInnerPosition(final TextBlock bloc, final String display) {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                bloc.drawU(ug);
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return bloc.calculateDimension(stringBounder);
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                return bloc.getMinMax(stringBounder);
            }

            @Override
            public XRectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                if (strategy.check(display, member)) {
                    XDimension2D dim = this.calculateDimension(stringBounder);
                    return new XRectangle2D(0.0, 0.0, dim.getWidth(), dim.getHeight());
                }
                return null;
            }

            @Override
            public MagneticBorder getMagneticBorder() {
                return bloc.getMagneticBorder();
            }

            @Override
            public HColor getBackcolor() {
                return bloc.getBackcolor();
            }
        };
    }

    public static TextBlock addBackcolor(final TextBlock text, final HColor backColor) {
        return new TextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                text.drawU(ug);
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                return text.getMinMax(stringBounder);
            }

            @Override
            public XRectangle2D getInnerPosition(String member, StringBounder stringBounder, InnerStrategy strategy) {
                return text.getInnerPosition(member, stringBounder, strategy);
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return text.calculateDimension(stringBounder);
            }

            @Override
            public HColor getBackcolor() {
                return backColor;
            }

            @Override
            public MagneticBorder getMagneticBorder() {
                return text.getMagneticBorder();
            }
        };
    }

    public static TextBlock fromUImage(final UImage image) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                ug.draw(image);
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D(image.getWidth(), image.getHeight());
            }

            @Override
            public MinMax getMinMax(StringBounder stringBounder) {
                return MinMax.fromMax(image.getWidth(), image.getHeight());
            }
        };
    }
}

