/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.png;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorMapper;
import znaishaded.net.sourceforge.plantuml.png.PngIOMetadata;
import znaishaded.net.sourceforge.plantuml.quantization.Quantizer;
import znaishaded.net.sourceforge.plantuml.security.SFile;
import znaishaded.net.sourceforge.plantuml.security.SImageIO;
import znaishaded.net.sourceforge.plantuml.utils.Log;

public class PngIO {
    private static final String copyleft = "Generated by https://plantuml.com";
    public static boolean USE_QUANTIZATION = false;

    public static void write(RenderedImage image, ColorMapper mapper, SFile file, String metadata, int dpi) throws IOException {
        try (BufferedOutputStream os = file.createBufferedOutputStream();){
            PngIO.write(image, mapper, os, metadata, dpi);
        }
        Log.debug("File is " + file);
        Log.debug("File size " + file.length());
        if (file.length() == 0L) {
            Log.error("File size is zero: " + file);
            SImageIO.write(image, "png", file);
        }
    }

    public static void write(RenderedImage image, ColorMapper mapper, OutputStream os, String metadata, int dpi) throws IOException {
        PngIO.write(image, mapper, os, metadata, dpi, null);
    }

    private static void write(RenderedImage image, ColorMapper mapper, OutputStream os, String metadata, int dpi, String debugData) throws IOException {
        if (USE_QUANTIZATION) {
            image = Quantizer.quantizeNow(mapper, (BufferedImage)image);
        }
        if (metadata == null) {
            SImageIO.write(image, "png", os);
        } else {
            PngIOMetadata.writeWithMetadata(image, os, metadata, dpi, debugData);
        }
    }
}

