/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project.command;

import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.project.GanttDiagram;
import znaishaded.net.sourceforge.plantuml.project.core.PrintScale;
import znaishaded.net.sourceforge.plantuml.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.regex.RegexOr;
import znaishaded.net.sourceforge.plantuml.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.utils.LineLocation;

public class CommandPrintScale
extends SingleLineCommand2<GanttDiagram> {
    public CommandPrintScale() {
        super(CommandPrintScale.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandPrintScale.class.getName(), RegexLeaf.start(), new RegexOr(new RegexLeaf("projectscale"), new RegexLeaf("ganttscale"), new RegexLeaf("printscale")), RegexLeaf.spaceOneOrMore(), new RegexOr("SCALE", new RegexLeaf("yearly"), new RegexLeaf("quarterly"), new RegexLeaf("monthly"), new RegexLeaf("daily"), new RegexLeaf("weekly")), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("DATE", "(with)"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("calendar"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("date"))), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf("zoom"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("ZOOM", "([.\\d]+)"))), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(GanttDiagram diagram, LineLocation location, RegexResult arg) {
        String withCalendarDate;
        String scaleString = arg.get("SCALE", 0);
        PrintScale scale = PrintScale.fromString(scaleString);
        diagram.setPrintScale(scale);
        String zoom = arg.get("ZOOM", 0);
        if (zoom != null) {
            diagram.setFactorScale(Double.parseDouble(zoom));
        }
        if ((withCalendarDate = arg.get("DATE", 0)) != null) {
            diagram.setWithCalendarDate(true);
        }
        return CommandExecutionResult.ok();
    }
}

