/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.real;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.log.Logme;
import znaishaded.net.sourceforge.plantuml.real.AbstractReal;
import znaishaded.net.sourceforge.plantuml.real.Real;
import znaishaded.net.sourceforge.plantuml.real.RealDelta;
import znaishaded.net.sourceforge.plantuml.real.RealLine;

class RealMax
extends AbstractReal
implements Real {
    private final List<Real> all = new ArrayList<Real>();
    private final Throwable creationPoint;

    RealMax(Collection<Real> reals) {
        super(RealMax.line(reals));
        this.all.addAll(reals);
        this.creationPoint = new Throwable();
        this.creationPoint.fillInStackTrace();
    }

    static RealLine line(Collection<Real> reals) {
        return ((AbstractReal)reals.iterator().next()).getLine();
    }

    @Override
    public String getName() {
        return "max " + this.all;
    }

    @Override
    double getCurrentValueInternal() {
        double result = this.all.get(0).getCurrentValue();
        for (int i = 1; i < this.all.size(); ++i) {
            Throwable t = new Throwable();
            t.fillInStackTrace();
            int stackLength = t.getStackTrace().length;
            if (stackLength > 1000) {
                System.err.println("The faulty RealMax " + this.getName());
                System.err.println("has been created here:");
                this.printCreationStackTrace();
                throw new IllegalStateException("Infinite recursion?");
            }
            double v = this.all.get(i).getCurrentValue();
            if (!(v > result)) continue;
            result = v;
        }
        return result;
    }

    @Override
    public Real addFixed(double delta) {
        return new RealDelta(this, delta);
    }

    @Override
    public Real addAtLeast(double delta) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void ensureBiggerThan(Real other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void printCreationStackTrace() {
        Logme.error(this.creationPoint);
    }
}

