/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.regexdiagram;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.regexdiagram.ReToken;
import znaishaded.net.sourceforge.plantuml.regexdiagram.ReTokenType;

public class ShuntingYard {
    private final List<ReToken> ouputQueue = new ArrayList<ReToken>();
    private final Deque<ReToken> operatorStack = new ArrayDeque<ReToken>();

    public ShuntingYard(Iterator<ReToken> it) {
        ReToken token;
        while (it.hasNext()) {
            token = it.next();
            if (token.getType() == ReTokenType.SIMPLE_CHAR) {
                this.ouputQueue.add(token);
                continue;
            }
            if (token.getType() == ReTokenType.ESCAPED_CHAR) {
                this.ouputQueue.add(token);
                continue;
            }
            if (token.getType() == ReTokenType.GROUP) {
                this.ouputQueue.add(token);
                continue;
            }
            if (token.getType() == ReTokenType.CLASS) {
                this.ouputQueue.add(token);
                continue;
            }
            if (token.getType() == ReTokenType.ANCHOR) {
                this.ouputQueue.add(token);
                continue;
            }
            if (token.getType() == ReTokenType.QUANTIFIER) {
                this.ouputQueue.add(token);
                continue;
            }
            if (token.getType() == ReTokenType.CONCATENATION_IMPLICIT) {
                this.operatorStack.addFirst(token);
                continue;
            }
            if (token.getType() == ReTokenType.ALTERNATIVE) {
                while (this.thereIsAConcatenationAtTheTopOfTheOperatorStack()) {
                    this.ouputQueue.add(this.operatorStack.removeFirst());
                }
                this.operatorStack.addFirst(token);
                continue;
            }
            if (token.getType() == ReTokenType.PARENTHESIS_OPEN) {
                this.operatorStack.addFirst(token);
                continue;
            }
            if (token.getType() == ReTokenType.PARENTHESIS_CLOSE) {
                while (this.operatorStack.peekFirst() != null && this.operatorStack.peekFirst().getType() != ReTokenType.PARENTHESIS_OPEN) {
                    this.ouputQueue.add(this.operatorStack.removeFirst());
                }
                ReToken reToken = this.operatorStack.removeFirst();
                continue;
            }
            throw new UnsupportedOperationException(token.toString());
        }
        while (!this.operatorStack.isEmpty()) {
            token = this.operatorStack.removeFirst();
            this.ouputQueue.add(token);
        }
    }

    private boolean thereIsAConcatenationAtTheTopOfTheOperatorStack() {
        ReToken top = this.operatorStack.peekFirst();
        return top != null && top.getType() == ReTokenType.CONCATENATION_IMPLICIT;
    }

    public final List<ReToken> getOuputQueue() {
        return Collections.unmodifiableList(this.ouputQueue);
    }
}

