/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.Objects;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.sequencediagram.InGroupable;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.GraphicalElement;
import znaishaded.net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.Component;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;
import znaishaded.net.sourceforge.plantuml.url.Url;

class GraphicalReference
extends GraphicalElement
implements InGroupable {
    private final Component comp;
    private final LivingParticipantBox livingParticipantBox1;
    private final LivingParticipantBox livingParticipantBox2;
    private final Url url;
    private final Component noteLeft;
    private final Component noteRight;

    public GraphicalReference(double startingY, Component comp, LivingParticipantBox livingParticipantBox1, LivingParticipantBox livingParticipantBox2, Url url, Component noteLeft, Component noteRight) {
        super(startingY);
        this.noteLeft = noteLeft;
        this.noteRight = noteRight;
        this.url = url;
        this.comp = comp;
        this.livingParticipantBox1 = Objects.requireNonNull(livingParticipantBox1);
        this.livingParticipantBox2 = Objects.requireNonNull(livingParticipantBox2);
    }

    @Override
    protected void drawInternalU(UGraphic ug, double maxX, Context2D context) {
        double hn;
        double wn;
        StringBounder stringBounder = ug.getStringBounder();
        ug = ug.apply(UTranslate.dy(this.getStartingY()));
        double r1 = this.getR1(stringBounder);
        double r2 = this.getR2(stringBounder);
        XDimension2D dim = new XDimension2D(r2 - r1, this.comp.getPreferredHeight(stringBounder));
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        this.comp.drawU(ug.apply(UTranslate.dx(r1)), new Area(dim), context);
        if (this.noteLeft != null) {
            wn = this.noteLeft.getPreferredWidth(stringBounder);
            hn = this.noteLeft.getPreferredHeight(stringBounder);
            this.noteLeft.drawU(ug, new Area(new XDimension2D(wn, hn)), context);
        }
        if (this.noteRight != null) {
            wn = this.noteRight.getPreferredWidth(stringBounder);
            hn = this.noteRight.getPreferredHeight(stringBounder);
            this.noteRight.drawU(ug.apply(UTranslate.dx(r2)), new Area(new XDimension2D(wn, hn)), context);
        }
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.comp.getPreferredHeight(stringBounder);
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        double result = this.comp.getPreferredWidth(stringBounder);
        if (this.noteLeft != null) {
            result += this.noteLeft.getPreferredWidth(stringBounder);
        }
        if (this.noteRight != null) {
            result += this.noteRight.getPreferredWidth(stringBounder);
        }
        return result;
    }

    private double getR1(StringBounder stringBounder) {
        return Math.min(this.livingParticipantBox1.getMinX(stringBounder), this.livingParticipantBox2.getMinX(stringBounder));
    }

    private double getR2(StringBounder stringBounder) {
        double diff = Math.max(this.livingParticipantBox1.getMaxX(stringBounder), this.livingParticipantBox2.getMaxX(stringBounder)) - this.getR1(stringBounder);
        double preferredWidth = this.comp.getPreferredWidth(stringBounder);
        double width = Math.max(diff, preferredWidth);
        return this.getR1(stringBounder) + width;
    }

    @Override
    public double getStartingX(StringBounder stringBounder) {
        return this.getMinX(stringBounder);
    }

    @Override
    public double getMinX(StringBounder stringBounder) {
        double result = this.getR1(stringBounder);
        if (this.noteLeft != null) {
            result -= this.noteLeft.getPreferredWidth(stringBounder);
        }
        return result;
    }

    @Override
    public double getMaxX(StringBounder stringBounder) {
        double result = this.getR2(stringBounder);
        if (this.noteRight != null) {
            result += this.noteRight.getPreferredWidth(stringBounder);
        }
        return result;
    }

    @Override
    public String toString(StringBounder stringBounder) {
        return this.toString();
    }
}

