/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek;

import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import znaishaded.net.sourceforge.plantuml.klimt.UChange;
import znaishaded.net.sourceforge.plantuml.klimt.UShape;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphicDelegator;

public class UGraphicForSnake
extends UGraphicDelegator {
    private final double dx;
    private final double dy;
    private final List<PendingSnake> snakes;

    @Override
    public String toString() {
        return "UGraphicForSnake " + this.getUg();
    }

    public UTranslate getTranslation() {
        return new UTranslate(this.dx, this.dy);
    }

    public UGraphicForSnake(UGraphic ug) {
        this(ug, 0.0, 0.0, new ArrayList<PendingSnake>());
    }

    private UGraphicForSnake(UGraphic ug, double dx, double dy, List<PendingSnake> snakes) {
        super(ug);
        this.dx = dx;
        this.dy = dy;
        this.snakes = snakes;
    }

    @Override
    public void draw(UShape shape) {
        if (shape instanceof Snake) {
            Snake snake = (Snake)shape;
            this.addPendingSnake(snake);
        } else {
            this.getUg().draw(shape);
        }
    }

    private void addPendingSnake(Snake snake) {
        PendingSnake newItem = new PendingSnake(snake, this.getUg(), this.dx, this.dy);
        for (int pos = 0; pos < this.snakes.size(); ++pos) {
            PendingSnake merge = this.snakes.get(pos).merge(newItem);
            if (merge == null) continue;
            this.snakes.set(pos, merge);
            return;
        }
        this.snakes.add(newItem);
    }

    @Override
    public void flushUg() {
        for (PendingSnake snake : this.snakes) {
            snake.removeEndDecorationIfTouches(this.snakes);
            snake.drawInternal();
        }
        this.snakes.clear();
    }

    @Override
    public UGraphic apply(UChange change) {
        double newdx = this.dx;
        double newdy = this.dy;
        if (change instanceof UTranslate) {
            newdx += ((UTranslate)change).getDx();
            newdy += ((UTranslate)change).getDy();
        }
        return new UGraphicForSnake(this.getUg().apply(change), newdx, newdy, this.snakes);
    }

    static class PendingSnake {
        private Snake snake;
        private final UGraphic ug;
        private final double dx;
        private final double dy;

        private PendingSnake(Snake snake, UGraphic ug, double dx, double dy) {
            this.snake = snake;
            this.ug = ug;
            this.dx = dx;
            this.dy = dy;
        }

        void drawInternal() {
            this.snake.drawInternal(this.ug);
        }

        void removeEndDecorationIfTouches(List<PendingSnake> snakes) {
            for (PendingSnake other : snakes) {
                if (!this.moved().touches(other.moved())) continue;
                this.snake = this.snake.withoutEndDecoration();
                return;
            }
        }

        private Snake moved() {
            return this.snake.move(this.dx, this.dy);
        }

        public String toString() {
            return "dx=" + this.dx + " dy=" + this.dy + " " + this.snake.move(this.dx, this.dy).toString();
        }

        public PendingSnake merge(PendingSnake newItem) {
            Snake s2;
            Snake s1 = this.snake.move(this.dx, this.dy);
            Snake merge = s1.merge(s2 = newItem.snake.move(newItem.dx, newItem.dy), this.ug.getStringBounder());
            if (merge == null) {
                return null;
            }
            return new PendingSnake(merge.move(-this.dx, -this.dy), this.ug, this.dx, this.dy);
        }
    }
}

