/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.abel.EntityPortion;
import znaishaded.net.sourceforge.plantuml.cucadiagram.BodyFactory;
import znaishaded.net.sourceforge.plantuml.cucadiagram.PortionShower;
import znaishaded.net.sourceforge.plantuml.klimt.Fashion;
import znaishaded.net.sourceforge.plantuml.klimt.UStroke;
import znaishaded.net.sourceforge.plantuml.klimt.UTranslate;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorType;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColor;
import znaishaded.net.sourceforge.plantuml.klimt.color.HColors;
import znaishaded.net.sourceforge.plantuml.klimt.drawing.UGraphic;
import znaishaded.net.sourceforge.plantuml.klimt.font.FontParam;
import znaishaded.net.sourceforge.plantuml.klimt.font.StringBounder;
import znaishaded.net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.klimt.geom.XDimension2D;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlock;
import znaishaded.net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.klimt.shape.UEllipse;
import znaishaded.net.sourceforge.plantuml.stereo.Stereotype;
import znaishaded.net.sourceforge.plantuml.style.ISkinParam;
import znaishaded.net.sourceforge.plantuml.style.SName;
import znaishaded.net.sourceforge.plantuml.style.Style;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.text.Guillemet;
import znaishaded.net.sourceforge.plantuml.url.Url;

public class EntityImageLollipopInterfaceEye2
extends AbstractEntityImage {
    public static final double SIZE = 14.0;
    private final TextBlock desc;
    private final TextBlock stereo;
    private final Fashion ctx;
    private final Url url;

    public EntityImageLollipopInterfaceEye2(Entity entity, ISkinParam skinParam, PortionShower portionShower) {
        super(entity, skinParam);
        Stereotype stereotype = entity.getStereotype();
        FontParam fontParam = FontParam.COMPONENT;
        this.desc = BodyFactory.create2(skinParam.getDefaultTextAlignment(HorizontalAlignment.CENTER), entity.getDisplay(), skinParam, stereotype, entity, this.getStyle(fontParam));
        this.url = entity.getUrl99();
        HColor backcolor = this.getEntity().getColors().getColor(ColorType.BACK);
        HColor forecolor = HColors.BLACK;
        this.ctx = new Fashion(backcolor, forecolor).withStroke(UStroke.withThickness(1.5)).withShadow(this.getSkinParam().shadowing(this.getEntity().getStereotype()) ? 3.0 : 0.0);
        this.stereo = stereotype != null && stereotype.getLabel(Guillemet.DOUBLE_COMPARATOR) != null && portionShower.showPortion(EntityPortion.STEREOTYPE, entity) ? TextBlockUtils.empty(0.0, 0.0) : TextBlockUtils.empty(0.0, 0.0);
    }

    private Style getStyle(FontParam fontParam) {
        return fontParam.getStyleDefinition(SName.componentDiagram).getMergedStyle(this.getSkinParam().getCurrentStyleBuilder());
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return new XDimension2D(14.0, 14.0);
    }

    @Override
    public final void drawU(UGraphic ug) {
        if (this.url != null) {
            ug.startUrl(this.url);
        }
        UEllipse circle = UEllipse.build(14.0, 14.0);
        if (this.getSkinParam().shadowing(this.getEntity().getStereotype())) {
            circle.setDeltaShadow(4.0);
        }
        this.ctx.apply(ug).draw(circle);
        XDimension2D dimDesc = this.desc.calculateDimension(ug.getStringBounder());
        double x1 = 7.0 - dimDesc.getWidth() / 2.0;
        double y1 = 19.599999999999998;
        this.desc.drawU(ug.apply(new UTranslate(x1, 19.599999999999998)));
        XDimension2D dimStereo = this.stereo.calculateDimension(ug.getStringBounder());
        double x2 = 7.0 - dimStereo.getWidth() / 2.0;
        double y2 = -dimStereo.getHeight();
        this.stereo.drawU(ug.apply(new UTranslate(x2, y2)));
        if (this.url != null) {
            ug.closeUrl();
        }
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.CIRCLE;
    }
}

