/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.swing;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;

public class ImageHelper {
    public static BufferedImage getScaledInstance(BufferedImage img, Dimension targetDim, RenderingHints hints, boolean higherQuality) {
        int h2;
        int w;
        int targetWidth = targetDim.width;
        int targetHeight = targetDim.height;
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        if (higherQuality) {
            w = img.getWidth();
            h2 = img.getHeight();
        } else {
            w = targetWidth;
            h2 = targetHeight;
        }
        do {
            if (higherQuality && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (higherQuality && h2 > targetHeight && (h2 /= 2) < targetHeight) {
                h2 = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h2, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHints(hints);
            g2.drawImage(ret, 0, 0, w, h2, null);
            g2.dispose();
            ret = tmp;
        } while (w != targetWidth || h2 != targetHeight);
        return ret;
    }

    public static BufferedImage toBufferedImage(Image img) {
        if (img instanceof BufferedImage) {
            return (BufferedImage)img;
        }
        BufferedImage bimage = new BufferedImage(img.getWidth(null), img.getHeight(null), 2);
        Graphics2D bGr = bimage.createGraphics();
        bGr.drawImage(img, 0, 0, null);
        bGr.dispose();
        return bimage;
    }

    public static Dimension getScaledDimension(Dimension imgSize, Dimension boundary) {
        int originalWidth = imgSize.width;
        int originaHeight = imgSize.height;
        int boundWidth = boundary.width;
        int boundHeight = boundary.height;
        int newWidth = originalWidth;
        int newHeight = originaHeight;
        if (originalWidth > boundWidth) {
            newWidth = boundWidth;
            newHeight = newWidth * originaHeight / originalWidth;
        }
        if (newHeight > boundHeight) {
            newHeight = boundHeight;
            newWidth = newHeight * originalWidth / originaHeight;
        }
        return new Dimension(newWidth, newHeight);
    }

    public static Dimension getScaledDimensionWidthFit(Dimension imgSize, Dimension boundary) {
        int originalWidth = imgSize.width;
        int originaHeight = imgSize.height;
        int boundWidth = boundary.width;
        int boundHeight = boundary.height;
        int newWidth = originalWidth;
        int newHeight = originaHeight;
        if (originalWidth != boundWidth) {
            newWidth = boundWidth;
            newHeight = newWidth * originaHeight / originalWidth;
        }
        return new Dimension(newWidth, newHeight);
    }

    public static Dimension getScaledDimension(Dimension dim, double zoom) {
        return new Dimension((int)(dim.getWidth() * zoom), (int)(dim.getHeight() * zoom));
    }
}

