/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.commonmark.ext.footnotes.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import znaishaded.org.commonmark.ext.footnotes.FootnoteDefinition;
import znaishaded.org.commonmark.ext.footnotes.FootnoteReference;
import znaishaded.org.commonmark.ext.footnotes.InlineFootnote;
import znaishaded.org.commonmark.node.AbstractVisitor;
import znaishaded.org.commonmark.node.CustomBlock;
import znaishaded.org.commonmark.node.CustomNode;
import znaishaded.org.commonmark.node.DefinitionMap;
import znaishaded.org.commonmark.node.Node;
import znaishaded.org.commonmark.node.Paragraph;
import znaishaded.org.commonmark.renderer.NodeRenderer;
import znaishaded.org.commonmark.renderer.html.HtmlNodeRendererContext;
import znaishaded.org.commonmark.renderer.html.HtmlWriter;

public class FootnoteHtmlNodeRenderer
implements NodeRenderer {
    private final HtmlWriter html;
    private final HtmlNodeRendererContext context;
    private DefinitionMap<FootnoteDefinition> definitionMap;
    private final Map<Node, ReferencedDefinition> referencedDefinitions = new LinkedHashMap<Node, ReferencedDefinition>();
    private final Map<Node, ReferenceInfo> references = new HashMap<Node, ReferenceInfo>();

    public FootnoteHtmlNodeRenderer(HtmlNodeRendererContext context) {
        this.html = context.getWriter();
        this.context = context;
    }

    @Override
    public Set<Class<? extends Node>> getNodeTypes() {
        return Set.of(FootnoteReference.class, InlineFootnote.class, FootnoteDefinition.class);
    }

    @Override
    public void beforeRoot(Node rootNode) {
        DefinitionVisitor visitor = new DefinitionVisitor();
        rootNode.accept(visitor);
        this.definitionMap = visitor.definitions;
    }

    @Override
    public void render(Node node) {
        if (node instanceof FootnoteReference) {
            ReferenceInfo info;
            FootnoteReference ref = (FootnoteReference)node;
            ReferenceInfo referenceInfo = info = this.references.containsKey(ref) ? this.references.get(ref) : this.tryRegisterReference(ref);
            if (info != null) {
                this.renderReference(ref, info);
            } else {
                this.html.text("[^" + ref.getLabel() + "]");
            }
        } else if (node instanceof InlineFootnote) {
            ReferenceInfo info = this.references.get(node);
            if (info == null) {
                info = this.registerReference(node, null);
            }
            this.renderReference(node, info);
        }
    }

    @Override
    public void afterRoot(Node rootNode) {
        if (this.referencedDefinitions.isEmpty()) {
            return;
        }
        Node firstDef = this.referencedDefinitions.keySet().iterator().next();
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        attrs.put("class", "footnotes");
        attrs.put("data-footnotes", null);
        this.html.tag("section", this.context.extendAttributes(firstDef, "section", attrs));
        this.html.line();
        this.html.tag("ol");
        this.html.line();
        LinkedList<Node> check = new LinkedList<Node>(this.referencedDefinitions.keySet());
        while (!check.isEmpty()) {
            Node def = check.removeFirst();
            def.accept(new ShallowReferenceVisitor(def, node -> {
                if (node instanceof FootnoteReference) {
                    FootnoteReference ref = (FootnoteReference)node;
                    FootnoteDefinition d = this.definitionMap.get(ref.getLabel());
                    if (d != null) {
                        if (!this.referencedDefinitions.containsKey(d)) {
                            check.addLast(d);
                        }
                        this.references.put(ref, this.registerReference(d, d.getLabel()));
                    }
                } else if (node instanceof InlineFootnote) {
                    check.addLast((Node)node);
                    this.references.put((Node)node, this.registerReference((Node)node, null));
                }
            }));
        }
        for (Map.Entry<Node, ReferencedDefinition> entry : this.referencedDefinitions.entrySet()) {
            this.renderDefinition(entry.getKey(), entry.getValue());
        }
        this.html.tag("/ol");
        this.html.line();
        this.html.tag("/section");
        this.html.line();
    }

    private ReferenceInfo tryRegisterReference(FootnoteReference ref) {
        FootnoteDefinition def = this.definitionMap.get(ref.getLabel());
        if (def == null) {
            return null;
        }
        return this.registerReference(def, def.getLabel());
    }

    private ReferenceInfo registerReference(Node node, String label) {
        ReferencedDefinition referencedDef = this.referencedDefinitions.computeIfAbsent(node, k -> {
            int num = this.referencedDefinitions.size() + 1;
            String key = this.definitionKey(label, num);
            return new ReferencedDefinition(num, key);
        });
        int definitionNumber = referencedDef.definitionNumber;
        int refNumber = referencedDef.references.size() + 1;
        String definitionKey = referencedDef.definitionKey;
        String id = this.referenceId(definitionKey, refNumber);
        referencedDef.references.add(id);
        return new ReferenceInfo(id, this.definitionId(definitionKey), definitionNumber);
    }

    private void renderReference(Node node, ReferenceInfo referenceInfo) {
        this.html.tag("sup", this.context.extendAttributes(node, "sup", Map.of("class", "footnote-ref")));
        String href = "#" + referenceInfo.definitionId;
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        attrs.put("href", href);
        attrs.put("id", referenceInfo.id);
        attrs.put("data-footnote-ref", null);
        this.html.tag("a", this.context.extendAttributes(node, "a", attrs));
        this.html.raw(String.valueOf(referenceInfo.definitionNumber));
        this.html.tag("/a");
        this.html.tag("/sup");
    }

    private void renderDefinition(Node def, ReferencedDefinition referencedDefinition) {
        LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
        attrs.put("id", this.definitionId(referencedDefinition.definitionKey));
        this.html.tag("li", this.context.extendAttributes(def, "li", attrs));
        this.html.line();
        if (def.getLastChild() instanceof Paragraph) {
            Paragraph lastParagraph = (Paragraph)def.getLastChild();
            for (Node node = def.getFirstChild(); node != lastParagraph; node = node.getNext()) {
                if (node instanceof Paragraph) {
                    this.html.tag("p", this.context.extendAttributes(node, "p", Map.of()));
                    this.renderChildren(node);
                    this.html.tag("/p");
                    this.html.line();
                    continue;
                }
                this.context.render(node);
            }
            this.html.tag("p", this.context.extendAttributes(lastParagraph, "p", Map.of()));
            this.renderChildren(lastParagraph);
            this.html.raw(" ");
            this.renderBackrefs(def, referencedDefinition);
            this.html.tag("/p");
            this.html.line();
        } else if (def instanceof InlineFootnote) {
            this.html.tag("p", this.context.extendAttributes(def, "p", Map.of()));
            this.renderChildren(def);
            this.html.raw(" ");
            this.renderBackrefs(def, referencedDefinition);
            this.html.tag("/p");
            this.html.line();
        } else {
            this.renderChildren(def);
            this.html.line();
            this.renderBackrefs(def, referencedDefinition);
        }
        this.html.tag("/li");
        this.html.line();
    }

    private void renderBackrefs(Node def, ReferencedDefinition referencedDefinition) {
        List<String> refs = referencedDefinition.references;
        for (int i = 0; i < refs.size(); ++i) {
            String ref = refs.get(i);
            int refNumber = i + 1;
            String idx = referencedDefinition.definitionNumber + (String)(refNumber > 1 ? "-" + refNumber : "");
            LinkedHashMap<String, String> attrs = new LinkedHashMap<String, String>();
            attrs.put("href", "#" + ref);
            attrs.put("class", "footnote-backref");
            attrs.put("data-footnote-backref", null);
            attrs.put("data-footnote-backref-idx", idx);
            attrs.put("aria-label", "Back to reference " + idx);
            this.html.tag("a", this.context.extendAttributes(def, "a", attrs));
            if (refNumber > 1) {
                this.html.tag("sup", this.context.extendAttributes(def, "sup", Map.of("class", "footnote-ref")));
                this.html.raw(String.valueOf(refNumber));
                this.html.tag("/sup");
            }
            this.html.raw("\u21a9");
            this.html.tag("/a");
            if (i + 1 >= refs.size()) continue;
            this.html.raw(" ");
        }
    }

    private String referenceId(String definitionKey, int number) {
        return "fnref" + definitionKey + (String)(number == 1 ? "" : "-" + number);
    }

    private String definitionKey(String label, int number) {
        if (label != null) {
            return "-" + label;
        }
        return "" + number;
    }

    private String definitionId(String definitionKey) {
        return "fn" + definitionKey;
    }

    private void renderChildren(Node parent) {
        Node node = parent.getFirstChild();
        while (node != null) {
            Node next = node.getNext();
            this.context.render(node);
            node = next;
        }
    }

    private static class ReferenceInfo {
        private final String id;
        private final String definitionId;
        private final int definitionNumber;

        private ReferenceInfo(String id, String definitionId, int definitionNumber) {
            this.id = id;
            this.definitionId = definitionId;
            this.definitionNumber = definitionNumber;
        }
    }

    private static class ReferencedDefinition {
        final int definitionNumber;
        final String definitionKey;
        final List<String> references = new ArrayList<String>();

        ReferencedDefinition(int definitionNumber, String definitionKey) {
            this.definitionNumber = definitionNumber;
            this.definitionKey = definitionKey;
        }
    }

    private static class ShallowReferenceVisitor
    extends AbstractVisitor {
        private final Node parent;
        private final Consumer<Node> consumer;

        private ShallowReferenceVisitor(Node parent, Consumer<Node> consumer) {
            this.parent = parent;
            this.consumer = consumer;
        }

        @Override
        public void visit(CustomNode customNode) {
            if (customNode instanceof FootnoteReference) {
                this.consumer.accept(customNode);
            } else if (customNode instanceof InlineFootnote) {
                if (customNode == this.parent) {
                    super.visit(customNode);
                } else {
                    this.consumer.accept(customNode);
                }
            } else {
                super.visit(customNode);
            }
        }
    }

    private static class DefinitionVisitor
    extends AbstractVisitor {
        private final DefinitionMap<FootnoteDefinition> definitions = new DefinitionMap<FootnoteDefinition>(FootnoteDefinition.class);

        private DefinitionVisitor() {
        }

        @Override
        public void visit(CustomBlock customBlock) {
            if (customBlock instanceof FootnoteDefinition) {
                FootnoteDefinition def = (FootnoteDefinition)customBlock;
                this.definitions.putIfAbsent(def.getLabel(), def);
            } else {
                super.visit(customBlock);
            }
        }
    }
}

