/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.commonmark.ext.footnotes.internal;

import znaishaded.org.commonmark.ext.footnotes.FootnoteDefinition;
import znaishaded.org.commonmark.ext.footnotes.FootnoteReference;
import znaishaded.org.commonmark.ext.footnotes.InlineFootnote;
import znaishaded.org.commonmark.node.LinkReferenceDefinition;
import znaishaded.org.commonmark.parser.InlineParserContext;
import znaishaded.org.commonmark.parser.beta.LinkInfo;
import znaishaded.org.commonmark.parser.beta.LinkProcessor;
import znaishaded.org.commonmark.parser.beta.LinkResult;
import znaishaded.org.commonmark.parser.beta.Position;
import znaishaded.org.commonmark.parser.beta.Scanner;

public class FootnoteLinkProcessor
implements LinkProcessor {
    @Override
    public LinkResult process(LinkInfo linkInfo, Scanner scanner, InlineParserContext context) {
        if (linkInfo.marker() != null && linkInfo.marker().getLiteral().equals("^")) {
            return LinkResult.wrapTextIn(new InlineFootnote(), linkInfo.afterTextBracket()).includeMarker();
        }
        if (linkInfo.destination() != null) {
            return LinkResult.none();
        }
        String text = linkInfo.text();
        if (!text.startsWith("^")) {
            return LinkResult.none();
        }
        if (linkInfo.label() != null && context.getDefinition(LinkReferenceDefinition.class, linkInfo.label()) != null) {
            return LinkResult.none();
        }
        String label = text.substring(1);
        FootnoteDefinition def = context.getDefinition(FootnoteDefinition.class, label);
        if (def == null) {
            return LinkResult.none();
        }
        Position position = linkInfo.afterTextBracket();
        return LinkResult.replaceWith(new FootnoteReference(label), position);
    }
}

