/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.commonmark.internal;

import znaishaded.org.commonmark.internal.util.Parsing;
import znaishaded.org.commonmark.node.Block;
import znaishaded.org.commonmark.node.Heading;
import znaishaded.org.commonmark.parser.InlineParser;
import znaishaded.org.commonmark.parser.SourceLine;
import znaishaded.org.commonmark.parser.SourceLines;
import znaishaded.org.commonmark.parser.beta.Position;
import znaishaded.org.commonmark.parser.beta.Scanner;
import znaishaded.org.commonmark.parser.block.AbstractBlockParser;
import znaishaded.org.commonmark.parser.block.AbstractBlockParserFactory;
import znaishaded.org.commonmark.parser.block.BlockContinue;
import znaishaded.org.commonmark.parser.block.BlockStart;
import znaishaded.org.commonmark.parser.block.MatchedBlockParser;
import znaishaded.org.commonmark.parser.block.ParserState;
import znaishaded.org.commonmark.text.Characters;

public class HeadingParser
extends AbstractBlockParser {
    private final Heading block = new Heading();
    private final SourceLines content;

    public HeadingParser(int level, SourceLines content) {
        this.block.setLevel(level);
        this.content = content;
    }

    @Override
    public Block getBlock() {
        return this.block;
    }

    @Override
    public BlockContinue tryContinue(ParserState parserState) {
        return BlockContinue.none();
    }

    @Override
    public void parseInlines(InlineParser inlineParser) {
        inlineParser.parse(this.content, this.block);
    }

    private static HeadingParser getAtxHeading(SourceLine line) {
        Position start;
        Scanner scanner = Scanner.of(SourceLines.of(line));
        int level = scanner.matchMultiple('#');
        if (level == 0 || level > 6) {
            return null;
        }
        if (!scanner.hasNext()) {
            return new HeadingParser(level, SourceLines.empty());
        }
        char next = scanner.peek();
        if (next != ' ' && next != '\t') {
            return null;
        }
        scanner.whitespace();
        Position end = start = scanner.position();
        boolean hashCanEnd = true;
        block4: while (scanner.hasNext()) {
            char c = scanner.peek();
            switch (c) {
                case '#': {
                    if (hashCanEnd) {
                        scanner.matchMultiple('#');
                        int whitespace = scanner.whitespace();
                        if (scanner.hasNext()) {
                            end = scanner.position();
                        }
                        hashCanEnd = whitespace > 0;
                        continue block4;
                    }
                    scanner.next();
                    end = scanner.position();
                    continue block4;
                }
                case '\t': 
                case ' ': {
                    hashCanEnd = true;
                    scanner.next();
                    continue block4;
                }
            }
            hashCanEnd = false;
            scanner.next();
            end = scanner.position();
        }
        SourceLines source = scanner.getSource(start, end);
        String content = source.getContent();
        if (content.isEmpty()) {
            return new HeadingParser(level, SourceLines.empty());
        }
        return new HeadingParser(level, source);
    }

    private static int getSetextHeadingLevel(CharSequence line, int index) {
        switch (line.charAt(index)) {
            case '=': {
                if (HeadingParser.isSetextHeadingRest(line, index + 1, '=')) {
                    return 1;
                }
            }
            case '-': {
                if (!HeadingParser.isSetextHeadingRest(line, index + 1, '-')) break;
                return 2;
            }
        }
        return 0;
    }

    private static boolean isSetextHeadingRest(CharSequence line, int index, char marker) {
        int afterMarker = Characters.skip(marker, line, index, line.length());
        int afterSpace = Characters.skipSpaceTab(line, afterMarker, line.length());
        return afterSpace >= line.length();
    }

    public static class Factory
    extends AbstractBlockParserFactory {
        @Override
        public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
            SourceLines paragraph;
            HeadingParser atxHeading;
            if (state.getIndent() >= Parsing.CODE_BLOCK_INDENT) {
                return BlockStart.none();
            }
            SourceLine line = state.getLine();
            int nextNonSpace = state.getNextNonSpaceIndex();
            if (line.getContent().charAt(nextNonSpace) == '#' && (atxHeading = HeadingParser.getAtxHeading(line.substring(nextNonSpace, line.getContent().length()))) != null) {
                return BlockStart.of(atxHeading).atIndex(line.getContent().length());
            }
            int setextHeadingLevel = HeadingParser.getSetextHeadingLevel(line.getContent(), nextNonSpace);
            if (setextHeadingLevel > 0 && !(paragraph = matchedBlockParser.getParagraphLines()).isEmpty()) {
                return BlockStart.of(new HeadingParser(setextHeadingLevel, paragraph)).atIndex(line.getContent().length()).replaceActiveBlockParser();
            }
            return BlockStart.none();
        }
    }
}

