/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.commonmark.internal.inline;

import java.util.Set;
import java.util.regex.Pattern;
import znaishaded.org.commonmark.node.Link;
import znaishaded.org.commonmark.node.Text;
import znaishaded.org.commonmark.parser.SourceLines;
import znaishaded.org.commonmark.parser.beta.InlineContentParser;
import znaishaded.org.commonmark.parser.beta.InlineContentParserFactory;
import znaishaded.org.commonmark.parser.beta.InlineParserState;
import znaishaded.org.commonmark.parser.beta.ParsedInline;
import znaishaded.org.commonmark.parser.beta.Position;
import znaishaded.org.commonmark.parser.beta.Scanner;

public class AutolinkInlineParser
implements InlineContentParser {
    private static final Pattern URI = Pattern.compile("^[a-zA-Z][a-zA-Z0-9.+-]{1,31}:[^<>\u0000- ]*$");
    private static final Pattern EMAIL = Pattern.compile("^([a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?(?:\\.[a-zA-Z0-9](?:[a-zA-Z0-9-]{0,61}[a-zA-Z0-9])?)*)$");

    @Override
    public ParsedInline tryParse(InlineParserState inlineParserState) {
        Scanner scanner = inlineParserState.scanner();
        scanner.next();
        Position textStart = scanner.position();
        if (scanner.find('>') > 0) {
            SourceLines textSource = scanner.getSource(textStart, scanner.position());
            String content = textSource.getContent();
            scanner.next();
            Object destination = null;
            if (URI.matcher(content).matches()) {
                destination = content;
            } else if (EMAIL.matcher(content).matches()) {
                destination = "mailto:" + content;
            }
            if (destination != null) {
                Link link = new Link((String)destination, null);
                Text text = new Text(content);
                text.setSourceSpans(textSource.getSourceSpans());
                link.appendChild(text);
                return ParsedInline.of(link, scanner.position());
            }
        }
        return ParsedInline.none();
    }

    public static class Factory
    implements InlineContentParserFactory {
        @Override
        public Set<Character> getTriggerCharacters() {
            return Set.of(Character.valueOf('<'));
        }

        @Override
        public InlineContentParser create() {
            return new AutolinkInlineParser();
        }
    }
}

