/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.file;

import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import org.testingisdocumenting.znai.extensions.PluginParamType;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginParamsDefinition;
import org.testingisdocumenting.znai.extensions.features.PluginFeature;
import org.testingisdocumenting.znai.structure.AnchorIds;
import org.testingisdocumenting.znai.structure.DocStructure;
import org.testingisdocumenting.znai.utils.NameUtils;

public class AnchorFeature
implements PluginFeature {
    public static final PluginParamsDefinition paramsDefinition = AnchorFeature.createParamsDefinition();
    private static final String ANCHOR_ID_KEY = "anchorId";
    private final DocStructure docStructure;
    private final Path markupPath;
    private final PluginParams pluginParams;

    public AnchorFeature(DocStructure docStructure, Path markupPath, PluginParams pluginParams) {
        this.docStructure = docStructure;
        this.markupPath = markupPath;
        this.pluginParams = pluginParams;
    }

    @Override
    public void updateProps(Map<String, Object> props) {
        String anchorId = this.pluginParams.getOpts().get(ANCHOR_ID_KEY, "");
        if (!anchorId.isEmpty()) {
            this.docStructure.registerLocalAnchors(this.markupPath, new AnchorIds(anchorId, Collections.emptyList()));
            return;
        }
        String title = this.pluginParams.getOpts().get("title", props.getOrDefault("title", "").toString());
        if (!title.isEmpty()) {
            AnchorIds uniqueAnchorIds = this.docStructure.generateUniqueAnchors(this.markupPath, NameUtils.idFromTitle(title));
            this.docStructure.registerLocalAnchors(this.markupPath, uniqueAnchorIds);
            props.put(ANCHOR_ID_KEY, uniqueAnchorIds.main());
        }
    }

    private static PluginParamsDefinition createParamsDefinition() {
        return new PluginParamsDefinition().add(ANCHOR_ID_KEY, PluginParamType.STRING, "anchor id to use for linking", "\"my_snippet\"");
    }
}

