/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.latex;

import java.util.Set;
import org.testingisdocumenting.znai.extensions.latex.LatexDollarBlock;
import org.testingisdocumenting.znai.extensions.latex.LatexDollarInline;
import znaishaded.org.commonmark.parser.beta.InlineContentParser;
import znaishaded.org.commonmark.parser.beta.InlineContentParserFactory;
import znaishaded.org.commonmark.parser.beta.InlineParserState;
import znaishaded.org.commonmark.parser.beta.ParsedInline;
import znaishaded.org.commonmark.parser.beta.Position;
import znaishaded.org.commonmark.parser.beta.Scanner;

public class LatexDollarParser
implements InlineContentParser {
    @Override
    public ParsedInline tryParse(InlineParserState state) {
        Scanner scanner = state.scanner();
        scanner.next();
        int numberOfWhiteSpaces = scanner.whitespace();
        if (numberOfWhiteSpaces > 0) {
            return ParsedInline.none();
        }
        char peek = scanner.peek();
        if (peek == '$') {
            return this.tryParseDoubleDollar(state);
        }
        return this.tryParseSingleDollar(state);
    }

    private ParsedInline tryParseDoubleDollar(InlineParserState state) {
        Scanner scanner = state.scanner();
        scanner.next();
        Position pos = scanner.position();
        boolean metDollar = this.scanUntilDollarWithNoSpace(state);
        if (!metDollar) {
            return ParsedInline.none();
        }
        char peek = scanner.peek();
        if (peek == '$') {
            String content = scanner.getSource(pos, scanner.position()).getContent().trim();
            scanner.next();
            scanner.next();
            return ParsedInline.of(new LatexDollarBlock(content), scanner.position());
        }
        return ParsedInline.none();
    }

    private ParsedInline tryParseSingleDollar(InlineParserState state) {
        Scanner scanner = state.scanner();
        Position pos = scanner.position();
        boolean metDollar = this.scanUntilDollarWithNoSpace(state);
        if (metDollar) {
            String content = scanner.getSource(pos, scanner.position()).getContent();
            scanner.next();
            return ParsedInline.of(new LatexDollarInline(content), scanner.position());
        }
        return ParsedInline.none();
    }

    private boolean scanUntilDollarWithNoSpace(InlineParserState state) {
        Scanner scanner = state.scanner();
        char prevChar;
        while ((prevChar = scanner.peek()) != '\u0000') {
            int whitespaceCount = scanner.whitespace();
            char currChar = scanner.peek();
            if (currChar == '$' && (whitespaceCount == 0 || whitespaceCount == 1 && prevChar == '\n')) {
                return true;
            }
            scanner.next();
        }
        return false;
    }

    public static class Factory
    implements InlineContentParserFactory {
        @Override
        public Set<Character> getTriggerCharacters() {
            return Set.of(Character.valueOf('$'));
        }

        @Override
        public InlineContentParser create() {
            return new LatexDollarParser();
        }
    }
}

