/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.parser;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.parser.MarkupParsingConfiguration;
import org.testingisdocumenting.znai.utils.ServiceLoaderUtils;

public class MarkupParsingConfigurations {
    private static final Set<MarkupParsingConfiguration> configurations = ServiceLoaderUtils.load(MarkupParsingConfiguration.class);

    private MarkupParsingConfigurations() {
    }

    public static void add(MarkupParsingConfiguration configuration) {
        configurations.add(configuration);
    }

    public static MarkupParsingConfiguration byName(String name) {
        List<MarkupParsingConfiguration> configurations = MarkupParsingConfigurations.configurations.stream().filter(c -> name.equals(c.configurationName())).toList();
        if (configurations.isEmpty()) {
            throw new RuntimeException("can't find markup configuration for <" + name + ">. Available configurations: \n" + MarkupParsingConfigurations.renderAvailable());
        }
        if (configurations.size() > 1) {
            throw new RuntimeException("more than one configuration found for <" + name + ">:\n" + MarkupParsingConfigurations.renderAvailable());
        }
        return configurations.get(0);
    }

    private static String renderAvailable() {
        return configurations.stream().map(c -> c.configurationName() + "(" + String.valueOf(c.getClass()) + ")").collect(Collectors.joining("\n"));
    }
}

