/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.parser.table;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.parser.commonmark.MarkdownVisitor;
import org.testingisdocumenting.znai.parser.docelement.DocElementCreationParserHandler;
import org.testingisdocumenting.znai.parser.table.MarkupTableData;
import org.testingisdocumenting.znai.parser.table.Row;
import znaishaded.org.commonmark.ext.gfm.tables.TableBlock;
import znaishaded.org.commonmark.ext.gfm.tables.TableBody;
import znaishaded.org.commonmark.ext.gfm.tables.TableCell;
import znaishaded.org.commonmark.ext.gfm.tables.TableHead;
import znaishaded.org.commonmark.ext.gfm.tables.TableRow;
import znaishaded.org.commonmark.node.AbstractVisitor;
import znaishaded.org.commonmark.node.CustomNode;

public class GfmTableToTableConverter
extends AbstractVisitor {
    private final ComponentsRegistry componentsRegistry;
    private final Path markdownPath;
    private final MarkupTableData tableData;
    private Row row;
    private boolean isHeader;

    public GfmTableToTableConverter(ComponentsRegistry componentsRegistry, Path markdownPath, TableBlock tableBlock) {
        this.componentsRegistry = componentsRegistry;
        this.markdownPath = markdownPath;
        this.tableData = new MarkupTableData();
        tableBlock.accept(this);
    }

    public MarkupTableData convert() {
        return this.tableData;
    }

    @Override
    public void visit(CustomNode customNode) {
        if (customNode instanceof TableHead) {
            this.isHeader = true;
            this.visitChildren(customNode);
        } else if (customNode instanceof TableBody) {
            this.isHeader = false;
            this.visitChildren(customNode);
        } else if (customNode instanceof TableRow) {
            this.row = new Row();
            this.visitChildren(customNode);
            if (!this.isHeader) {
                this.tableData.addRow(this.row);
            }
        } else if (customNode instanceof TableCell) {
            if (this.isHeader) {
                this.handleHeaderCell((TableCell)customNode);
            } else {
                this.handleBodyCell((TableCell)customNode);
            }
        } else {
            throw new UnsupportedOperationException("can't handle: " + String.valueOf(customNode));
        }
    }

    private void handleHeaderCell(TableCell headerCell) {
        this.tableData.addColumn(this.extractTitle(headerCell), this.extractAlignment(headerCell));
    }

    private String extractTitle(TableCell headerCell) {
        List<Map<String, Object>> docElements = this.contentFromCell(headerCell);
        return docElements.get(0).get("text").toString();
    }

    private String extractAlignment(TableCell headerCell) {
        if (headerCell == null || headerCell.getAlignment() == null) {
            return "left";
        }
        return switch (headerCell.getAlignment()) {
            case TableCell.Alignment.CENTER -> "center";
            case TableCell.Alignment.RIGHT -> "right";
            default -> "left";
        };
    }

    private void handleBodyCell(TableCell bodyCell) {
        List<Map<String, Object>> content = this.contentFromCell(bodyCell);
        this.row.add(content);
    }

    private List<Map<String, Object>> contentFromCell(TableCell bodyCell) {
        DocElementCreationParserHandler handler = new DocElementCreationParserHandler(this.componentsRegistry, this.markdownPath);
        MarkdownVisitor markdownVisitor = new MarkdownVisitor(this.componentsRegistry, this.markdownPath, handler);
        bodyCell.accept(markdownVisitor);
        return (List)handler.getDocElement().toMap().get("content");
    }
}

