/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.server.preview;

import java.nio.file.Path;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Function;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.console.ansi.Color;
import org.testingisdocumenting.znai.server.HttpServerUtils;
import org.testingisdocumenting.znai.server.NoAuthenticationHandler;
import org.testingisdocumenting.znai.server.SslConfig;
import org.testingisdocumenting.znai.server.ZnaiServer;
import org.testingisdocumenting.znai.server.preview.FileWatcher;
import org.testingisdocumenting.znai.server.preview.PreviewPushFileChangeHandler;
import org.testingisdocumenting.znai.server.preview.PreviewSendChangesWebSocketHandler;
import org.testingisdocumenting.znai.server.preview.PreviewUpdatePathWebSocketHandler;
import org.testingisdocumenting.znai.server.sockets.WebSocketHandlers;
import org.testingisdocumenting.znai.website.WebSite;
import znaishaded.io.vertx.core.http.HttpServer;
import znaishaded.org.apache.commons.io.FileUtils;

public class DocumentationPreview {
    private static final ExecutorService SINGLE_THREAD_POOL_EXECUTOR = Executors.newSingleThreadExecutor();
    private final Path sourceRoot;
    private final Path deployRoot;
    private WebSite webSite;
    private FileWatcher fileWatcher;
    private Function<Path, WebSite> createWebSite;
    private PreviewSendChangesWebSocketHandler previewSendChangesWebSocketHandler;
    private PreviewUpdatePathWebSocketHandler previewUpdatePathWebSocketHandler;

    public DocumentationPreview(Path sourceRoot, Path deployRoot) {
        this.sourceRoot = sourceRoot;
        this.deployRoot = deployRoot;
    }

    public void start(Function<Path, WebSite> createWebSite, SslConfig sslConfig, int port, Runnable onStart) {
        this.createWebSite = createWebSite;
        this.previewSendChangesWebSocketHandler = new PreviewSendChangesWebSocketHandler();
        this.buildWebSiteAndFileWatcher(this.sourceRoot);
        this.reportPhase("starting server");
        ZnaiServer znaiServer = new ZnaiServer(this.deployRoot, new NoAuthenticationHandler(), sslConfig);
        this.previewUpdatePathWebSocketHandler = new PreviewUpdatePathWebSocketHandler(this::changePreviewSourceRoot);
        WebSocketHandlers.add(this.previewSendChangesWebSocketHandler);
        WebSocketHandlers.add(this.previewUpdatePathWebSocketHandler);
        ConsoleOutputs.add(this.previewUpdatePathWebSocketHandler);
        HttpServer server = znaiServer.create();
        HttpServerUtils.listen(server, port);
        onStart.run();
        this.fileWatcher.start();
    }

    public void changePreviewSourceRoot(Path sourceRoot) {
        SINGLE_THREAD_POOL_EXECUTOR.submit(() -> {
            try {
                this.clearFileWatcher();
                this.cleanDeployRoot();
                this.buildWebSiteAndFileWatcher(sourceRoot);
                this.sendCompletionSignal();
                new Thread(() -> this.fileWatcher.start()).start();
            }
            catch (Throwable e) {
                ConsoleOutputs.err(e.getMessage());
            }
        });
    }

    private void sendCompletionSignal() {
        this.previewUpdatePathWebSocketHandler.sendCompletion();
    }

    private void buildWebSiteAndFileWatcher(Path sourceRoot) {
        this.reportPhase("building webs site", sourceRoot);
        this.webSite = this.createWebSite.apply(sourceRoot);
        this.reportPhase("initializing file watcher");
        PreviewPushFileChangeHandler fileChangeHandler = new PreviewPushFileChangeHandler(this.previewSendChangesWebSocketHandler, this.webSite);
        this.fileWatcher = new FileWatcher(this.webSite.getCfg(), Stream.concat(this.webSite.getAuxiliaryFilesRegistry().getAllPaths(), this.webSite.getToc().getResolvedPaths().stream()), fileChangeHandler);
        this.webSite.getAuxiliaryFilesRegistry().registerListener(this.fileWatcher);
        this.webSite.registerTocChangeListener(this.fileWatcher);
    }

    private void cleanDeployRoot() {
        Path pathToClean = this.deployRoot.resolve("preview");
        this.reportPhase("cleaning deploy root", pathToClean);
        FileUtils.deleteQuietly(pathToClean.toFile());
    }

    private void clearFileWatcher() {
        this.reportPhase("unsubscribing from file changes");
        this.webSite.unregisterTocChangeListener(this.fileWatcher);
        this.webSite.getAuxiliaryFilesRegistry().unregisterListener(this.fileWatcher);
        this.reportPhase("stopping file watcher");
        this.fileWatcher.stop();
    }

    private void reportPhase(String phase) {
        ConsoleOutputs.out(new Object[]{Color.BLUE, phase});
    }

    private void reportPhase(String phase, Object param) {
        ConsoleOutputs.out(new Object[]{Color.BLUE, phase, " ", Color.PURPLE, param});
    }
}

