/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.typescript;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.parser.commonmark.MarkdownParser;
import org.testingisdocumenting.znai.typescript.TypeScriptCode;
import org.testingisdocumenting.znai.typescript.TypeScriptFunction;
import org.testingisdocumenting.znai.typescript.TypeScriptJsxDeclaration;
import org.testingisdocumenting.znai.typescript.TypeScriptProperty;
import org.testingisdocumenting.znai.typescript.TypeScriptType;
import org.testingisdocumenting.znai.typescript.TypescriptNodeBasedParser;

public class TypeScriptIncludePlugin
implements IncludePlugin {
    private Path fullPath;
    private MarkdownParser markdownParser;
    private TypeScriptCode typeScriptCode;

    @Override
    public String id() {
        return "typescript";
    }

    @Override
    public IncludePlugin create() {
        return new TypeScriptIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.markdownParser = componentsRegistry.markdownParser();
        this.fullPath = componentsRegistry.resourceResolver().fullPath(pluginParams.getFreeParam());
        List<Map<String, ?>> entries = ParserSingleton.INSTANCE.parsedFile(this.fullPath);
        this.typeScriptCode = new TypeScriptCode(entries);
        String propertiesOf = pluginParams.getOpts().get("propertiesOf", "");
        if (!propertiesOf.isEmpty()) {
            return this.extractPropertiesOf(propertiesOf);
        }
        String jsxElementsFrom = pluginParams.getOpts().get("jsxElementsFrom", "");
        if (!jsxElementsFrom.isEmpty()) {
            return this.extractJsxElementsFrom(jsxElementsFrom);
        }
        throw new UnsupportedOperationException("only support propertiesOf");
    }

    private PluginResult extractPropertiesOf(String propertiesOf) {
        TypeScriptType type = this.typeScriptCode.findType(propertiesOf);
        List parameters = type.getProperties().stream().map(this::propertyToMap).collect(Collectors.toList());
        return PluginResult.docElement("ApiParameters", Collections.singletonMap("parameters", parameters));
    }

    private PluginResult extractJsxElementsFrom(String jsxElementsFrom) {
        String[] path = jsxElementsFrom.split("\\.");
        if (path.length == 1) {
            return this.extractJsxElementsFromFunction(path[0]);
        }
        if (path.length == 2) {
            return this.extractJsxElementsFromMethod(path[0], path[1]);
        }
        throw new RuntimeException("pass either function name or method name to extract jsx elements from");
    }

    private PluginResult extractJsxElementsFromMethod(String typeName, String methodName) {
        throw new UnsupportedOperationException("extracting jsx elements from type's method is not supported yet");
    }

    private PluginResult extractJsxElementsFromFunction(String funcName) {
        TypeScriptFunction function = this.typeScriptCode.findFunction(funcName);
        List<Map> declarations = function.getJsxDeclarations().stream().map(TypeScriptJsxDeclaration::toMap).toList();
        return PluginResult.docElement("JsxGroup", Collections.singletonMap("declarations", declarations));
    }

    private Map<String, ?> propertyToMap(TypeScriptProperty p) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("name", p.getName());
        map.put("type", p.getType());
        MarkupParserResult markupParserResult = this.markdownParser.parse(this.fullPath, p.getDocumentation());
        map.put("description", markupParserResult.docElement().contentToListOfMaps());
        return map;
    }

    public static void main(String[] args) {
        List<Map<String, ?>> parsedFile = ParserSingleton.INSTANCE.parsedFile(Paths.get("/Users/mykolagolubyev/work/TestingIsDocumenting/znai-typescript/src/main/javascript/test-data/Sample.ts", new String[0]));
        System.out.println(parsedFile);
    }

    private static class ParserSingleton {
        private static final TypescriptNodeBasedParser INSTANCE = new TypescriptNodeBasedParser();

        private ParserSingleton() {
        }
    }
}

