/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.common;

import java.util.Collection;
import java.util.HashSet;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.github.fge.jackson.JsonNumEquivalence;
import znaishaded.com.github.fge.jackson.NodeType;
import znaishaded.com.github.fge.jackson.jsonpointer.JsonPointer;
import znaishaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.AbstractSyntaxChecker;
import znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import znaishaded.com.github.fge.jsonschema.core.tree.SchemaTree;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;
import znaishaded.com.google.common.base.Equivalence;
import znaishaded.com.google.common.collect.Sets;

public final class EnumSyntaxChecker
extends AbstractSyntaxChecker {
    private static final Equivalence<JsonNode> EQUIVALENCE = JsonNumEquivalence.getInstance();
    private static final SyntaxChecker INSTANCE = new EnumSyntaxChecker();

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    private EnumSyntaxChecker() {
        super("enum", NodeType.ARRAY, new NodeType[0]);
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, MessageBundle bundle, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        HashSet<Equivalence.Wrapper<JsonNode>> set = Sets.newHashSet();
        for (JsonNode element : this.getNode(tree)) {
            if (set.add(EQUIVALENCE.wrap(element))) continue;
            report.error(this.newMsg(tree, bundle, "common.array.duplicateElements"));
            return;
        }
    }
}

