/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.hyperschema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.github.fge.jackson.NodeType;
import znaishaded.com.github.fge.jackson.jsonpointer.JsonPointer;
import znaishaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.AbstractSyntaxChecker;
import znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingMessage;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import znaishaded.com.github.fge.jsonschema.core.tree.SchemaTree;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;
import znaishaded.com.github.fge.uritemplate.URITemplate;
import znaishaded.com.github.fge.uritemplate.URITemplateParseException;
import znaishaded.com.google.common.collect.ImmutableList;
import znaishaded.com.google.common.collect.Lists;
import znaishaded.com.google.common.collect.Sets;
import znaishaded.com.google.common.net.MediaType;

public final class LinksSyntaxChecker
extends AbstractSyntaxChecker {
    private static final ImmutableList<String> REQUIRED_LDO_PROPERTIES = ImmutableList.of("href", "rel");
    private static final SyntaxChecker INSTANCE = new LinksSyntaxChecker();

    private LinksSyntaxChecker() {
        super("links", NodeType.ARRAY, new NodeType[0]);
    }

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, MessageBundle bundle, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        JsonNode node = this.getNode(tree);
        int size = node.size();
        for (int index = 0; index < size; ++index) {
            JsonNode ldo = this.getNode(tree).get(index);
            NodeType type = NodeType.getNodeType(ldo);
            if (type != NodeType.OBJECT) {
                report.error(this.LDOMsg(tree, bundle, "draftv4.ldo.incorrectType", index).put("expected", NodeType.OBJECT).putArgument("found", type));
                continue;
            }
            HashSet<String> set = Sets.newHashSet(ldo.fieldNames());
            ArrayList<String> list = Lists.newArrayList(REQUIRED_LDO_PROPERTIES);
            list.removeAll(set);
            if (!list.isEmpty()) {
                ProcessingMessage msg = this.LDOMsg(tree, bundle, "draftv4.ldo.missingRequired", index);
                report.error(msg.put("required", REQUIRED_LDO_PROPERTIES).putArgument("missing", list));
                continue;
            }
            if (ldo.has("schema")) {
                pointers.add(JsonPointer.of(this.keyword, index, "schema"));
            }
            if (ldo.has("targetSchema")) {
                pointers.add(JsonPointer.of(this.keyword, index, "targetSchema"));
            }
            this.checkLDO(report, bundle, tree, index);
        }
    }

    private void checkLDO(ProcessingReport report, MessageBundle bundle, SchemaTree tree, int index) throws ProcessingException {
        String value;
        JsonNode ldo = this.getNode(tree).get(index);
        this.checkLDOProperty(report, bundle, tree, index, "rel", NodeType.STRING, "draftv4.ldo.rel.incorrectType");
        if (this.checkLDOProperty(report, bundle, tree, index, "href", NodeType.STRING, "draftv4.ldo.href.incorrectType")) {
            value = ldo.get("href").textValue();
            try {
                new URITemplate(value);
            }
            catch (URITemplateParseException ignored) {
                report.error(this.LDOMsg(tree, bundle, "draftv4.ldo.href.notURITemplate", index).putArgument("value", value));
            }
        }
        this.checkLDOProperty(report, bundle, tree, index, "title", NodeType.STRING, "draftv4.ldo.title.incorrectType");
        if (this.checkLDOProperty(report, bundle, tree, index, "mediaType", NodeType.STRING, "draftv4.ldo.mediaType.incorrectType")) {
            value = ldo.get("mediaType").textValue();
            try {
                MediaType.parse(value);
            }
            catch (IllegalArgumentException ignored) {
                report.error(this.LDOMsg(tree, bundle, "draftv4.ldo.mediaType.notMediaType", index).putArgument("value", value));
            }
        }
        this.checkLDOProperty(report, bundle, tree, index, "method", NodeType.STRING, "draftv4.ldo.method.incorrectType");
        if (this.checkLDOProperty(report, bundle, tree, index, "encType", NodeType.STRING, "draftv4.ldo.enctype.incorrectType")) {
            value = ldo.get("encType").textValue();
            try {
                MediaType.parse(value);
            }
            catch (IllegalArgumentException ignored) {
                report.error(this.LDOMsg(tree, bundle, "draftv4.ldo.enctype.notMediaType", index).putArgument("value", value));
            }
        }
    }

    private ProcessingMessage LDOMsg(SchemaTree tree, MessageBundle bundle, String key, int index) {
        return this.newMsg(tree, bundle, key).put("index", index);
    }

    private boolean checkLDOProperty(ProcessingReport report, MessageBundle bundle, SchemaTree tree, int index, String name, NodeType expected, String key) throws ProcessingException {
        JsonNode node = this.getNode(tree).get(index).get(name);
        if (node == null) {
            return false;
        }
        NodeType type = NodeType.getNodeType(node);
        if (type == expected) {
            return true;
        }
        report.error(this.LDOMsg(tree, bundle, key, index).put("expected", expected).putArgument("found", type));
        return false;
    }
}

