/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.hyperschema;

import java.util.Collection;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.github.fge.jackson.NodeType;
import znaishaded.com.github.fge.jackson.jsonpointer.JsonPointer;
import znaishaded.com.github.fge.jsonschema.core.exceptions.ProcessingException;
import znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.AbstractSyntaxChecker;
import znaishaded.com.github.fge.jsonschema.core.keyword.syntax.checkers.SyntaxChecker;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import znaishaded.com.github.fge.jsonschema.core.tree.SchemaTree;
import znaishaded.com.github.fge.msgsimple.bundle.MessageBundle;
import znaishaded.com.google.common.collect.ImmutableSet;
import znaishaded.com.google.common.net.MediaType;

public final class MediaSyntaxChecker
extends AbstractSyntaxChecker {
    private static final String BINARY_ENCODING_FIELDNAME = "binaryEncoding";
    private static final String TYPE_FIELDNAME = "type";
    private static final ImmutableSet<String> BINARY_ENCODINGS = ImmutableSet.of("7bit", "8bit", "binary", "quoted-printable", "base64");
    private static final SyntaxChecker INSTANCE = new MediaSyntaxChecker();

    private MediaSyntaxChecker() {
        super("media", NodeType.OBJECT, new NodeType[0]);
    }

    public static SyntaxChecker getInstance() {
        return INSTANCE;
    }

    @Override
    protected void checkValue(Collection<JsonPointer> pointers, MessageBundle bundle, ProcessingReport report, SchemaTree tree) throws ProcessingException {
        String value;
        NodeType type;
        JsonNode node = this.getNode(tree);
        JsonNode subNode = node.path(BINARY_ENCODING_FIELDNAME);
        if (!subNode.isMissingNode()) {
            type = NodeType.getNodeType(subNode);
            value = subNode.textValue();
            if (value == null) {
                report.error(this.newMsg(tree, bundle, "draftv4.media.binaryEncoding.incorrectType").put("expected", NodeType.STRING).putArgument("found", type));
            } else if (!BINARY_ENCODINGS.contains(value.toLowerCase())) {
                report.error(this.newMsg(tree, bundle, "draftv4.media.binaryEncoding.invalid").putArgument("value", value).putArgument("valid", BINARY_ENCODINGS));
            }
        }
        if ((subNode = node.path(TYPE_FIELDNAME)).isMissingNode()) {
            return;
        }
        type = NodeType.getNodeType(subNode);
        if (type != NodeType.STRING) {
            report.error(this.newMsg(tree, bundle, "draftv4.media.type.incorrectType").put("expected", NodeType.STRING).putArgument("found", type));
            return;
        }
        value = subNode.textValue();
        try {
            MediaType.parse(value);
        }
        catch (IllegalArgumentException ignored) {
            report.error(this.newMsg(tree, bundle, "draftv4.media.type.notMediaType").putArgument("value", value));
        }
    }
}

