/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.core.report;

import java.util.Iterator;
import java.util.List;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.fasterxml.jackson.databind.node.ArrayNode;
import znaishaded.com.fasterxml.jackson.databind.node.JsonNodeFactory;
import znaishaded.com.github.fge.jackson.JacksonUtils;
import znaishaded.com.github.fge.jsonschema.core.report.AbstractProcessingReport;
import znaishaded.com.github.fge.jsonschema.core.report.LogLevel;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingMessage;
import znaishaded.com.github.fge.jsonschema.core.report.ProcessingReport;
import znaishaded.com.github.fge.jsonschema.core.util.AsJson;
import znaishaded.com.google.common.collect.Iterators;
import znaishaded.com.google.common.collect.Lists;

public final class ListProcessingReport
extends AbstractProcessingReport
implements AsJson {
    private static final JsonNodeFactory FACTORY = JacksonUtils.nodeFactory();
    private final List<ProcessingMessage> messages = Lists.newArrayList();

    public ListProcessingReport(LogLevel logLevel, LogLevel exceptionThreshold) {
        super(logLevel, exceptionThreshold);
    }

    public ListProcessingReport(LogLevel logLevel) {
        super(logLevel);
    }

    public ListProcessingReport() {
    }

    public ListProcessingReport(ProcessingReport other) {
        this(other.getLogLevel(), other.getExceptionThreshold());
    }

    @Override
    public void log(LogLevel level, ProcessingMessage message) {
        this.messages.add(message);
    }

    @Override
    public JsonNode asJson() {
        ArrayNode ret = FACTORY.arrayNode();
        for (ProcessingMessage message : this.messages) {
            ret.add(message.asJson());
        }
        return ret;
    }

    @Override
    public Iterator<ProcessingMessage> iterator() {
        return Iterators.unmodifiableIterator(this.messages.iterator());
    }
}

