/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.github.fge.jsonschema.keyword.digest.draftv3;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.fasterxml.jackson.databind.node.ArrayNode;
import znaishaded.com.fasterxml.jackson.databind.node.ObjectNode;
import znaishaded.com.github.fge.jackson.JacksonUtils;
import znaishaded.com.github.fge.jackson.NodeType;
import znaishaded.com.github.fge.jsonschema.keyword.digest.AbstractDigester;
import znaishaded.com.github.fge.jsonschema.keyword.digest.Digester;
import znaishaded.com.google.common.collect.Lists;
import znaishaded.com.google.common.collect.Ordering;
import znaishaded.com.google.common.collect.Sets;

public final class DraftV3DependenciesDigester
extends AbstractDigester {
    private static final Digester INSTANCE = new DraftV3DependenciesDigester();

    public static Digester getInstance() {
        return INSTANCE;
    }

    private DraftV3DependenciesDigester() {
        super("dependencies", NodeType.OBJECT, new NodeType[0]);
    }

    @Override
    public JsonNode digest(JsonNode schema) {
        ObjectNode ret = FACTORY.objectNode();
        ObjectNode propertyDeps = FACTORY.objectNode();
        ret.set("propertyDeps", propertyDeps);
        ArrayNode schemaDeps = FACTORY.arrayNode();
        ret.set("schemaDeps", schemaDeps);
        ArrayList<String> list = Lists.newArrayList();
        Map<String, JsonNode> map = JacksonUtils.asMap(schema.get(this.keyword));
        for (Map.Entry<String, JsonNode> entry : map.entrySet()) {
            String key = entry.getKey();
            JsonNode value = entry.getValue();
            NodeType type = NodeType.getNodeType(value);
            switch (type) {
                case OBJECT: {
                    list.add(key);
                    break;
                }
                case ARRAY: {
                    JsonNode node = DraftV3DependenciesDigester.sortedSet(value);
                    if (node.size() == 0) break;
                    propertyDeps.set(key, node);
                    break;
                }
                case STRING: {
                    propertyDeps.set(key, FACTORY.arrayNode().add(value.textValue()));
                    break;
                }
            }
        }
        for (String s2 : Ordering.natural().sortedCopy(list)) {
            schemaDeps.add(s2);
        }
        return ret;
    }

    private static JsonNode sortedSet(JsonNode node) {
        TreeSet<JsonNode> set = Sets.newTreeSet(new Comparator<JsonNode>(){

            @Override
            public int compare(JsonNode o1, JsonNode o2) {
                return o1.textValue().compareTo(o2.textValue());
            }
        });
        set.addAll(Sets.newHashSet(node));
        ArrayNode ret = FACTORY.arrayNode();
        ret.addAll(set);
        return ret;
    }
}

