/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.google.common.graph;

import java.util.AbstractSet;
import java.util.Map;
import javax.annotation.CheckForNull;
import znaishaded.com.google.common.base.Preconditions;
import znaishaded.com.google.common.collect.ImmutableSet;
import znaishaded.com.google.common.collect.Iterators;
import znaishaded.com.google.common.collect.UnmodifiableIterator;
import znaishaded.com.google.common.graph.ElementTypesAreNonnullByDefault;

@ElementTypesAreNonnullByDefault
final class EdgesConnecting<E>
extends AbstractSet<E> {
    private final Map<?, E> nodeToOutEdge;
    private final Object targetNode;

    EdgesConnecting(Map<?, E> nodeToEdgeMap, Object targetNode) {
        this.nodeToOutEdge = Preconditions.checkNotNull(nodeToEdgeMap);
        this.targetNode = Preconditions.checkNotNull(targetNode);
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        E connectingEdge = this.getConnectingEdge();
        return connectingEdge == null ? ImmutableSet.of().iterator() : Iterators.singletonIterator(connectingEdge);
    }

    @Override
    public int size() {
        return this.getConnectingEdge() == null ? 0 : 1;
    }

    @Override
    public boolean contains(@CheckForNull Object edge) {
        E connectingEdge = this.getConnectingEdge();
        return connectingEdge != null && connectingEdge.equals(edge);
    }

    @CheckForNull
    private E getConnectingEdge() {
        return this.nodeToOutEdge.get(this.targetNode);
    }
}

