/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.parser.urlresolver.utils;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;

public class NetUtils {
    private NetUtils() {
    }

    public static InetAddress getHostByName(String hostname) throws UnknownHostException {
        return InetAddress.getByName(hostname);
    }

    public static String getHostFromUrl(String url) throws MalformedURLException {
        String hostnameOrIP = new URL(url).getHost();
        if (hostnameOrIP.length() > 2 && hostnameOrIP.startsWith("[") && hostnameOrIP.endsWith("]")) {
            return hostnameOrIP.substring(1, hostnameOrIP.length() - 1);
        }
        return hostnameOrIP;
    }

    public static String setHost(String url, String host) throws MalformedURLException {
        URL parsed = new URL(url);
        if (NetUtils.isIPv6(host)) {
            return url.replace(parsed.getHost(), "[" + host + "]");
        }
        return url.replace(parsed.getHost(), host);
    }

    public static boolean isIPv4(String ipAddress) {
        boolean isIPv4 = false;
        if (ipAddress != null) {
            try {
                InetAddress inetAddress = InetAddress.getByName(ipAddress);
                isIPv4 = inetAddress instanceof Inet4Address;
            }
            catch (UnknownHostException ignored) {
                return false;
            }
        }
        return isIPv4;
    }

    public static boolean isIPv6(String ipAddress) {
        boolean isIPv6 = false;
        if (ipAddress != null) {
            try {
                InetAddress inetAddress = InetAddress.getByName(ipAddress);
                isIPv6 = inetAddress instanceof Inet6Address;
            }
            catch (UnknownHostException ignored) {
                return false;
            }
        }
        return isIPv6;
    }

    public static boolean isUniqueLocalAddress(InetAddress ip) {
        if (ip instanceof Inet4Address) {
            return false;
        }
        byte[] address = ip.getAddress();
        return (address[0] & 0xFF) == 252 || (address[0] & 0xFF) == 253;
    }

    public static boolean isNAT64Address(InetAddress ip) {
        if (ip instanceof Inet4Address) {
            return false;
        }
        byte[] address = ip.getAddress();
        return (address[0] & 0xFF) == 0 && (address[1] & 0xFF) == 100 && (address[2] & 0xFF) == 255 && (address[3] & 0xFF) == 155;
    }
}

