/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.transform.migrate;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import znaishaded.com.fasterxml.jackson.databind.JsonNode;
import znaishaded.com.fasterxml.jackson.databind.ObjectMapper;
import znaishaded.com.github.fge.jackson.JacksonUtils;
import znaishaded.com.github.fge.jackson.jsonpointer.JsonPointer;
import znaishaded.com.github.fge.jsonpatch.JsonPatch;
import znaishaded.io.swagger.transform.migrate.SwaggerMigrator;
import znaishaded.io.swagger.transform.util.SwaggerMigrationException;
import znaishaded.io.swagger.transform.util.SwaggerMigrators;

public final class V11AllowableValuesMigrator
implements SwaggerMigrator {
    private static final ObjectMapper MAPPER = JacksonUtils.newMapper();
    private static final JsonPatch PATCH;

    @Override
    @Nonnull
    public JsonNode migrate(@Nonnull JsonNode input) throws SwaggerMigrationException {
        Objects.requireNonNull(input);
        if (!input.has("allowableValues")) {
            return input;
        }
        String valueType = JsonPointer.of("allowableValues", "valueType").get(input).textValue();
        if ("LIST".equals(valueType)) {
            return SwaggerMigrators.fromPatch(PATCH).migrate(input);
        }
        return input;
    }

    static {
        String op = "[                                              \n  {                                            \n    \"op\": \"move\",                          \n    \"from\": \"/allowableValues/values\",     \n    \"path\": \"/enum\"                        \n  },                                           \n  {                                            \n    \"op\": \"remove\",                        \n    \"path\": \"/allowableValues\"             \n  }                                            \n]";
        try {
            PATCH = MAPPER.readValue("[                                              \n  {                                            \n    \"op\": \"move\",                          \n    \"from\": \"/allowableValues/values\",     \n    \"path\": \"/enum\"                        \n  },                                           \n  {                                            \n    \"op\": \"remove\",                        \n    \"path\": \"/allowableValues\"             \n  }                                            \n]", JsonPatch.class);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

