/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.v3.core.util;

import java.lang.annotation.Annotation;
import znaishaded.io.swagger.v3.core.util.ReflectionUtils;

public class KotlinDetector {
    private static final Boolean kotlinAvailable = KotlinDetector.loadByClassOrNull("kotlin.Metadata") != null;
    private static final Class<? extends Annotation> kotlinDeprecated = KotlinDetector.loadByClassOrNull("kotlin.Deprecated");

    private static <T> Class<T> loadByClassOrNull(String className) {
        try {
            return ReflectionUtils.loadClassByName(className);
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
    }

    public static boolean isKotlinPresent() {
        return kotlinAvailable;
    }

    public static Class<? extends Annotation> getKotlinDeprecated() {
        return kotlinDeprecated;
    }
}

