/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.v3.parser.processors;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import znaishaded.io.swagger.v3.oas.models.OpenAPI;
import znaishaded.io.swagger.v3.oas.models.Operation;
import znaishaded.io.swagger.v3.oas.models.PathItem;
import znaishaded.io.swagger.v3.oas.models.Paths;
import znaishaded.io.swagger.v3.oas.models.callbacks.Callback;
import znaishaded.io.swagger.v3.oas.models.examples.Example;
import znaishaded.io.swagger.v3.oas.models.media.ArraySchema;
import znaishaded.io.swagger.v3.oas.models.media.ComposedSchema;
import znaishaded.io.swagger.v3.oas.models.media.Content;
import znaishaded.io.swagger.v3.oas.models.media.MediaType;
import znaishaded.io.swagger.v3.oas.models.media.Schema;
import znaishaded.io.swagger.v3.oas.models.parameters.Parameter;
import znaishaded.io.swagger.v3.oas.models.parameters.RequestBody;
import znaishaded.io.swagger.v3.oas.models.responses.ApiResponse;
import znaishaded.io.swagger.v3.parser.OpenAPIResolver;
import znaishaded.io.swagger.v3.parser.ResolverCache;
import znaishaded.io.swagger.v3.parser.models.RefFormat;
import znaishaded.io.swagger.v3.parser.processors.ExternalRefProcessor;
import znaishaded.io.swagger.v3.parser.processors.OperationProcessor;
import znaishaded.io.swagger.v3.parser.processors.ParameterProcessor;
import znaishaded.io.swagger.v3.parser.util.RefUtils;

public class PathsProcessor {
    private final OpenAPI openAPI;
    private final ResolverCache cache;
    private final OpenAPIResolver.Settings settings;
    private final ParameterProcessor parameterProcessor;
    private final OperationProcessor operationProcessor;
    private final ExternalRefProcessor externalRefProcessor;

    public PathsProcessor(ResolverCache cache, OpenAPI openAPI) {
        this(cache, openAPI, new OpenAPIResolver.Settings());
    }

    public PathsProcessor(ResolverCache cache, OpenAPI openAPI, OpenAPIResolver.Settings settings) {
        this(cache, openAPI, settings, false);
    }

    public PathsProcessor(ResolverCache cache, OpenAPI openAPI, OpenAPIResolver.Settings settings, boolean openapi31) {
        this.openAPI = openAPI;
        this.cache = cache;
        this.settings = settings;
        this.parameterProcessor = new ParameterProcessor(cache, openAPI, openapi31);
        this.operationProcessor = new OperationProcessor(cache, openAPI, openapi31);
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
    }

    public void processPaths() {
        Paths pathMap = this.openAPI.getPaths();
        if (pathMap == null) {
            return;
        }
        for (String pathStr : pathMap.keySet()) {
            PathItem pathItem = (PathItem)pathMap.get(pathStr);
            if (pathItem.get$ref() != null) {
                PathItem resolvedPath = this.processReferencePath(pathItem);
                String pathRef = pathItem.get$ref().split("#")[0];
                if (resolvedPath != null) {
                    this.updateRefs(resolvedPath, pathRef);
                    this.openAPI.path(pathStr, resolvedPath);
                    pathItem = resolvedPath;
                }
            }
            this.addParametersToEachOperation(pathItem);
            List<Parameter> processedPathParameters = this.parameterProcessor.processParameters(pathItem.getParameters());
            pathItem.setParameters(processedPathParameters);
            Map<PathItem.HttpMethod, Operation> operationMap = pathItem.readOperationsMap();
            for (PathItem.HttpMethod httpMethod : operationMap.keySet()) {
                Operation operation = operationMap.get((Object)httpMethod);
                this.operationProcessor.processOperation(operation);
            }
        }
    }

    private void addParametersToEachOperation(PathItem pathItem) {
        if (this.settings.addParametersToEachOperation()) {
            List<Operation> operations;
            List<Parameter> parameters = pathItem.getParameters();
            if (parameters != null && (operations = pathItem.readOperations()) != null) {
                for (Operation operation : operations) {
                    ArrayList<Parameter> parametersToAdd = new ArrayList<Parameter>();
                    List<Parameter> existingParameters = operation.getParameters();
                    if (existingParameters == null) {
                        existingParameters = new ArrayList<Parameter>();
                        operation.setParameters(existingParameters);
                    }
                    for (Parameter parameterToAdd : parameters) {
                        boolean matched = false;
                        for (Parameter existingParameter : existingParameters) {
                            if (parameterToAdd.getIn() == null || !parameterToAdd.getIn().equals(existingParameter.getIn()) || !parameterToAdd.getName().equals(existingParameter.getName())) continue;
                            matched = true;
                        }
                        if (matched) continue;
                        parametersToAdd.add(parameterToAdd);
                    }
                    if (parametersToAdd.size() <= 0) continue;
                    operation.getParameters().addAll(0, parametersToAdd);
                }
            }
            pathItem.setParameters(null);
        }
    }

    protected void updateRefs(PathItem path, String pathRef) {
        if (path.getParameters() != null) {
            List<Parameter> params = path.getParameters();
            for (Parameter param : params) {
                this.updateRefs(param, pathRef);
            }
        }
        List<Operation> ops = path.readOperations();
        for (Operation op : ops) {
            if (op.getParameters() != null) {
                for (Parameter param : op.getParameters()) {
                    this.updateRefs(param, pathRef);
                }
            }
            if (op.getResponses() != null) {
                for (ApiResponse response : op.getResponses().values()) {
                    this.updateRefs(response, pathRef);
                }
            }
            if (op.getRequestBody() != null) {
                this.updateRefs(op.getRequestBody(), pathRef);
            }
            if (op.getCallbacks() == null) continue;
            Map<String, Callback> callbacks = op.getCallbacks();
            for (String name : callbacks.keySet()) {
                Callback callback = callbacks.get(name);
                if (callback == null) continue;
                if (callback.get$ref() != null) {
                    callback.set$ref(this.computeRef(callback.get$ref(), pathRef));
                }
                for (String callbackName : callback.keySet()) {
                    PathItem pathItem = (PathItem)callback.get(callbackName);
                    this.updateRefs(pathItem, pathRef);
                }
            }
        }
    }

    protected void updateRefs(ApiResponse response, String pathRef) {
        if (response.get$ref() != null) {
            response.set$ref(this.computeRef(response.get$ref(), pathRef));
        }
        if (response.getContent() != null) {
            Content content = response.getContent();
            for (String key : content.keySet()) {
                Map<String, Example> examples;
                MediaType mediaType = (MediaType)content.get(key);
                if (mediaType.getSchema() != null) {
                    this.updateRefs(mediaType.getSchema(), pathRef);
                }
                if ((examples = ((MediaType)content.get(key)).getExamples()) == null) continue;
                for (Example example : examples.values()) {
                    this.updateRefs(example, pathRef);
                }
            }
        }
    }

    protected void updateRefs(Example example, String pathRef) {
        if (example.get$ref() != null) {
            example.set$ref(this.computeRef(example.get$ref(), pathRef));
        }
    }

    protected void updateRefs(Parameter param, String pathRef) {
        if (param.get$ref() != null) {
            param.set$ref(this.computeRef(param.get$ref(), pathRef));
        }
        if (param.getSchema() != null) {
            this.updateRefs(param.getSchema(), pathRef);
        }
        if (param.getContent() != null) {
            Content content = param.getContent();
            for (String key : content.keySet()) {
                MediaType mediaType = (MediaType)content.get(key);
                if (mediaType.getSchema() == null) continue;
                this.updateRefs(mediaType.getSchema(), pathRef);
            }
        }
    }

    protected void updateRefs(RequestBody body, String pathRef) {
        if (body.get$ref() != null) {
            body.set$ref(this.computeRef(body.get$ref(), pathRef));
        }
        if (body.getContent() != null) {
            Content content = body.getContent();
            for (String key : content.keySet()) {
                Map<String, Example> examples;
                MediaType mediaType = (MediaType)content.get(key);
                if (mediaType.getSchema() != null) {
                    this.updateRefs(mediaType.getSchema(), pathRef);
                }
                if ((examples = ((MediaType)content.get(key)).getExamples()) == null) continue;
                for (Example example : examples.values()) {
                    this.updateRefs(example, pathRef);
                }
            }
        } else if (body.get$ref() != null) {
            // empty if block
        }
    }

    protected void updateRefs(Schema model, String pathRef) {
        ArraySchema arraySchema;
        if (model.get$ref() != null) {
            model.set$ref(this.computeRef(model.get$ref(), pathRef));
        } else if (model.getProperties() != null) {
            if (model.getProperties() != null) {
                Map<String, Schema> properties = model.getProperties();
                for (String key : properties.keySet()) {
                    Schema property = properties.get(key);
                    if (property == null) continue;
                    this.updateRefs(property, pathRef);
                }
            }
        } else if (model instanceof ComposedSchema) {
            ComposedSchema composedSchema = (ComposedSchema)model;
            if (composedSchema.getAllOf() != null) {
                for (Schema innerModel2 : composedSchema.getAllOf()) {
                    this.updateRefs(innerModel2, pathRef);
                }
            }
            if (composedSchema.getAnyOf() != null || composedSchema.getOneOf() != null) {
                HashMap refMappings = composedSchema.getDiscriminator() != null && composedSchema.getDiscriminator().getMapping() != null ? new HashMap() : null;
                Stream.of(composedSchema.getAnyOf(), composedSchema.getOneOf()).filter(Objects::nonNull).filter(l -> !l.isEmpty()).flatMap(Collection::stream).forEach(innerModel -> {
                    String oldRef = innerModel.get$ref();
                    this.updateRefs((Schema)innerModel, pathRef);
                    if (oldRef != null && refMappings != null && !oldRef.equals(innerModel.get$ref())) {
                        refMappings.put(oldRef, innerModel.get$ref());
                    }
                });
                if (refMappings != null && !refMappings.isEmpty()) {
                    Map<String, String> discriminatorMappings = composedSchema.getDiscriminator().getMapping();
                    for (String key : discriminatorMappings.keySet()) {
                        if (!refMappings.containsKey(discriminatorMappings.get(key))) continue;
                        discriminatorMappings.put(key, (String)refMappings.get(discriminatorMappings.get(key)));
                    }
                }
            }
        } else if (model instanceof ArraySchema && (arraySchema = (ArraySchema)model).getItems() != null) {
            this.updateRefs(arraySchema.getItems(), pathRef);
        }
    }

    protected boolean isLocalRef(String ref) {
        return ref.startsWith("#");
    }

    protected boolean isAbsoluteRef(String ref) {
        return !ref.startsWith(".");
    }

    private boolean isInternalSchemaRef(String $ref) {
        return $ref.startsWith("#/components/schemas");
    }

    protected String computeRef(String ref, String prefix) {
        if (this.isLocalRef(ref) && !this.isInternalSchemaRef(ref)) {
            return this.computeLocalRef(ref, prefix);
        }
        if (this.isAbsoluteRef(ref)) {
            return ref;
        }
        if (this.isInternalSchemaRef(ref)) {
            return ref;
        }
        return this.computeRelativeRef(ref, prefix);
    }

    protected String computeRelativeRef(String ref, String prefix) {
        if (ref.startsWith("./")) {
            return ref;
        }
        int iIdxOfSlash = prefix.lastIndexOf(47);
        if (iIdxOfSlash != -1) {
            return prefix.substring(0, iIdxOfSlash + 1) + ref;
        }
        return prefix + ref;
    }

    protected String computeLocalRef(String ref, String prefix) {
        return prefix + ref;
    }

    public PathItem processReferencePath(PathItem pathItem) {
        RefFormat refFormat = RefUtils.computeRefFormat(pathItem.get$ref());
        String $ref = pathItem.get$ref();
        pathItem = RefUtils.isAnExternalRefFormat(refFormat) ? this.externalRefProcessor.processRefToExternalPathItem($ref, refFormat) : this.cache.loadRef(pathItem.get$ref(), refFormat, PathItem.class);
        return pathItem;
    }
}

