/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.swagger.v3.parser.processors;

import java.util.Map;
import znaishaded.io.swagger.v3.oas.models.OpenAPI;
import znaishaded.io.swagger.v3.oas.models.examples.Example;
import znaishaded.io.swagger.v3.oas.models.headers.Header;
import znaishaded.io.swagger.v3.oas.models.links.Link;
import znaishaded.io.swagger.v3.oas.models.media.Content;
import znaishaded.io.swagger.v3.oas.models.media.MediaType;
import znaishaded.io.swagger.v3.oas.models.media.Schema;
import znaishaded.io.swagger.v3.oas.models.responses.ApiResponse;
import znaishaded.io.swagger.v3.parser.ResolverCache;
import znaishaded.io.swagger.v3.parser.models.RefFormat;
import znaishaded.io.swagger.v3.parser.processors.ExampleProcessor;
import znaishaded.io.swagger.v3.parser.processors.ExternalRefProcessor;
import znaishaded.io.swagger.v3.parser.processors.HeaderProcessor;
import znaishaded.io.swagger.v3.parser.processors.LinkProcessor;
import znaishaded.io.swagger.v3.parser.processors.SchemaProcessor;
import znaishaded.io.swagger.v3.parser.util.RefUtils;

public class ResponseProcessor {
    private final SchemaProcessor schemaProcessor;
    private final HeaderProcessor headerProcessor;
    private final LinkProcessor linkProcessor;
    private final ExternalRefProcessor externalRefProcessor;
    private final ExampleProcessor exampleProcessor;
    private final ResolverCache cache;
    private final OpenAPI openAPI;

    public ResponseProcessor(ResolverCache cache, OpenAPI openAPI) {
        this(cache, openAPI, false);
    }

    public ResponseProcessor(ResolverCache cache, OpenAPI openAPI, boolean openapi31) {
        this.schemaProcessor = new SchemaProcessor(cache, openAPI, openapi31);
        this.headerProcessor = new HeaderProcessor(cache, openAPI, openapi31);
        this.linkProcessor = new LinkProcessor(cache, openAPI, openapi31);
        this.exampleProcessor = new ExampleProcessor(cache, openAPI);
        this.externalRefProcessor = new ExternalRefProcessor(cache, openAPI);
        this.cache = cache;
        this.openAPI = openAPI;
    }

    public void processResponse(ApiResponse response) {
        if (response.get$ref() != null) {
            this.processReferenceResponse(response);
        }
        Schema schema = null;
        if (response.getContent() != null) {
            Content content = response.getContent();
            for (String mediaName : content.keySet()) {
                MediaType mediaType = (MediaType)content.get(mediaName);
                if (mediaType.getSchema() != null && (schema = mediaType.getSchema()) != null) {
                    this.schemaProcessor.processSchema(schema);
                }
                if (mediaType.getExamples() == null) continue;
                for (Example ex : mediaType.getExamples().values()) {
                    this.exampleProcessor.processExample(ex);
                }
            }
        }
        if (response.getHeaders() != null) {
            Map<String, Header> headers = response.getHeaders();
            for (String headerName : headers.keySet()) {
                Header header = headers.get(headerName);
                this.headerProcessor.processHeader(header);
            }
        }
        if (response.getLinks() != null) {
            Map<String, Link> links = response.getLinks();
            for (String linkName : links.keySet()) {
                Link link = links.get(linkName);
                this.linkProcessor.processLink(link);
            }
        }
    }

    public void processReferenceResponse(ApiResponse response) {
        String newRef;
        RefFormat refFormat = RefUtils.computeRefFormat(response.get$ref());
        String $ref = response.get$ref();
        if (RefUtils.isAnExternalRefFormat(refFormat) && (newRef = this.externalRefProcessor.processRefToExternalResponse($ref, refFormat)) != null) {
            response.set$ref(newRef);
        }
    }
}

