/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram.command;

import java.util.List;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.abel.Entity;
import znaishaded.net.sourceforge.plantuml.abel.GroupType;
import znaishaded.net.sourceforge.plantuml.abel.LeafType;
import znaishaded.net.sourceforge.plantuml.abel.Link;
import znaishaded.net.sourceforge.plantuml.abel.LinkArg;
import znaishaded.net.sourceforge.plantuml.activitydiagram.ActivityDiagram;
import znaishaded.net.sourceforge.plantuml.activitydiagram.command.CommandLinkActivity;
import znaishaded.net.sourceforge.plantuml.classdiagram.command.CommandLinkClass;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilines2;
import znaishaded.net.sourceforge.plantuml.command.MultilinesStrategy;
import znaishaded.net.sourceforge.plantuml.command.Trim;
import znaishaded.net.sourceforge.plantuml.decoration.LinkDecor;
import znaishaded.net.sourceforge.plantuml.decoration.LinkType;
import znaishaded.net.sourceforge.plantuml.klimt.color.ColorType;
import znaishaded.net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import znaishaded.net.sourceforge.plantuml.klimt.creole.Display;
import znaishaded.net.sourceforge.plantuml.plasma.Quark;
import znaishaded.net.sourceforge.plantuml.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.regex.RegexOptional;
import znaishaded.net.sourceforge.plantuml.regex.RegexOr;
import znaishaded.net.sourceforge.plantuml.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.stereo.Stereotype;
import znaishaded.net.sourceforge.plantuml.text.StringLocated;
import znaishaded.net.sourceforge.plantuml.url.Url;
import znaishaded.net.sourceforge.plantuml.url.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.url.UrlMode;
import znaishaded.net.sourceforge.plantuml.utils.BlocLines;
import znaishaded.net.sourceforge.plantuml.utils.Direction;

public class CommandLinkLongActivity
extends CommandMultilines2<ActivityDiagram> {
    public CommandLinkLongActivity() {
        super(CommandLinkLongActivity.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE, Trim.BOTH);
    }

    @Override
    public String getPatternEnd() {
        return "^[%s]*([^%g]*)[%g](?:[%s]+as[%s]+([%pLN][%pLN_.]*))?[%s]*(\\<\\<.*\\>\\>)?[%s]*(?:in[%s]+([%g][^%g]+[%g]|\\S+))?[%s]*(#\\w+)?$";
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandLinkLongActivity.class.getName(), RegexLeaf.start(), new RegexOptional((IRegex)new RegexOr("FIRST", new RegexLeaf("STAR", "(\\(\\*(top)?\\))"), new RegexLeaf("CODE", "([%pLN][%pLN_.]*)"), new RegexLeaf("BAR", "(?:==+)[%s]*([%pLN_.]+)[%s]*(?:==+)"), new RegexLeaf("QUOTED", "[%g]([^%g]+)[%g](?:[%s]+as[%s]+([%pLN_.]+))?"))), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("BACKCOLOR", "(#\\w+)?"), RegexLeaf.spaceZeroOrMore(), UrlBuilder.OPTIONAL, new RegexLeaf("ARROW_BODY1", "([-.]+)"), new RegexLeaf("ARROW_STYLE1", "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)\\])?"), new RegexLeaf("ARROW_DIRECTION", "(\\*|left|right|up|down|le?|ri?|up?|do?)?"), new RegexLeaf("ARROW_STYLE2", "(?:\\[((?:#\\w+|dotted|dashed|plain|bold|hidden|norank|single|thickness=\\d+)(?:,#\\w+|,dotted|,dashed|,plain|,bold|,hidden|,norank|,single|,thickness=\\d+)*)\\])?"), new RegexLeaf("ARROW_BODY2", "([-.]*)"), new RegexLeaf("\\>"), RegexLeaf.spaceZeroOrMore(), new RegexOptional((IRegex)new RegexLeaf("BRACKET", "\\[([^\\]*]+[^\\]]*)\\]")), RegexLeaf.spaceZeroOrMore(), new RegexLeaf("[%g]"), new RegexLeaf("DESC", "([^%g]*?)"), RegexLeaf.spaceZeroOrMore(), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeNow(ActivityDiagram diagram, BlocLines lines) throws NoSuchColorException {
        Quark<Entity> ident;
        Entity entity2;
        String stringColor;
        lines = lines.trim();
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        Entity entity1 = CommandLinkActivity.getEntity(diagram, line0, true);
        if (entity1 == null) {
            return CommandExecutionResult.error("No such entity");
        }
        if (line0.get("STEREOTYPE", 0) != null) {
            entity1.setStereotype(Stereotype.build(line0.get("STEREOTYPE", 0)));
        }
        if ((stringColor = line0.get("BACKCOLOR", 0)) != null) {
            entity1.setSpecificColorTOBEREMOVED(ColorType.BACK, diagram.getSkinParam().getIHtmlColorSet().getColor(stringColor));
        }
        StringBuilder sb = new StringBuilder();
        String desc0 = line0.get("DESC", 0);
        Url urlActivity = null;
        if (StringUtils.isNotEmpty(desc0) && (urlActivity = this.extractUrlString(diagram, desc0)) == null) {
            sb.append(desc0);
            sb.append("\\n");
        }
        int i = 0;
        for (StringLocated cs : lines.subExtract(1, 1)) {
            if (++i == 1 && urlActivity == null && (urlActivity = this.extractUrl(diagram, cs)) != null) continue;
            sb.append(cs.getString());
            if (i >= lines.size() - 2) continue;
            sb.append("\\n");
        }
        List<String> lineLast = StringUtils.getSplit(MyPattern.cmpile(this.getPatternEnd()), lines.getLast().getString());
        if (StringUtils.isNotEmpty(lineLast.get(0))) {
            if (sb.length() > 0 && !sb.toString().endsWith("\\n")) {
                sb.append("\\n");
            }
            sb.append(lineLast.get(0));
        }
        String display = sb.toString();
        String idShort = lineLast.get(1) == null ? display : lineLast.get(1);
        String partition = null;
        if (lineLast.get(3) != null) {
            partition = lineLast.get(3);
            partition = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(partition);
        }
        if (partition != null) {
            Quark<Entity> idNewLong = diagram.quarkInContext(true, diagram.cleanId(partition));
            diagram.gotoGroup(idNewLong, Display.getWithNewlines(partition), GroupType.PACKAGE);
        }
        if ((entity2 = (ident = diagram.quarkInContext(true, diagram.cleanId(idShort))).getData()) == null) {
            entity2 = diagram.reallyCreateLeaf(ident, Display.getWithNewlines(display), LeafType.ACTIVITY, null);
        }
        diagram.setLastEntityConsulted(entity2);
        if (partition != null) {
            diagram.endGroup();
        }
        if (urlActivity != null) {
            entity2.addUrl(urlActivity);
        }
        if (lineLast.get(2) != null) {
            entity2.setStereotype(Stereotype.build(lineLast.get(2)));
        }
        if (lineLast.get(4) != null) {
            String s2 = lineLast.get(4);
            entity2.setSpecificColorTOBEREMOVED(ColorType.BACK, diagram.getSkinParam().getIHtmlColorSet().getColor(s2));
        }
        String arrowBody1 = CommandLinkClass.notNull(line0.get("ARROW_BODY1", 0));
        String arrowBody2 = CommandLinkClass.notNull(line0.get("ARROW_BODY2", 0));
        String arrowDirection = CommandLinkClass.notNull(line0.get("ARROW_DIRECTION", 0));
        String arrow = StringUtils.manageArrowForCuca(arrowBody1 + arrowDirection + arrowBody2 + ">");
        int lenght = arrow.length() - 1;
        Display linkLabel = Display.getWithNewlines(line0.get("BRACKET", 0));
        LinkType type = new LinkType(LinkDecor.ARROW, LinkDecor.NONE);
        if (arrow.contains(".")) {
            type = type.goDotted();
        }
        LinkArg linkArg = LinkArg.build(linkLabel, lenght, diagram.getSkinParam().classAttributeIconSize() > 0);
        Link link = new Link(diagram.getEntityFactory(), diagram.getSkinParam().getCurrentStyleBuilder(), entity1, entity2, type, linkArg);
        Direction direction = StringUtils.getArrowDirection(arrowBody1 + arrowDirection + arrowBody2 + ">");
        if (direction == Direction.LEFT || direction == Direction.UP) {
            link = link.getInv();
        }
        if (line0.get("URL", 0) != null) {
            UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
            Url urlLink = urlBuilder.getUrl(line0.get("URL", 0));
            link.setUrl(urlLink);
        }
        link.applyStyle(line0.getLazzy("ARROW_STYLE", 0));
        diagram.addLink(link);
        return CommandExecutionResult.ok();
    }

    public Url extractUrl(ActivityDiagram diagram, StringLocated string) {
        return this.extractUrlString(diagram, string.getString());
    }

    public Url extractUrlString(ActivityDiagram diagram, String string) {
        UrlBuilder urlBuilder = new UrlBuilder(diagram.getSkinParam().getValue("topurl"), UrlMode.STRICT);
        return urlBuilder.getUrl(string);
    }
}

